// --------------------------------- string handling ---------------------------------------
function _int(str,pos) {
   if (pos!=undefined) str=str.slice(pos);
   return parseInt(str,10);
}

function _combine(proj,comp) {
   var projStr="00"+proj;
   var compStr="00"+comp;
   return projStr.slice(-3)+compStr.slice(-3);
}

function _capitalise(name) {
   var cap,rest;
   var nameParts=name.split(" ");
   for (var i=0;i<nameParts.length;i++) {
      rest=nameParts[i].slice(1);
      cap=nameParts[i].charAt(0);
      if (i==0) name=cap.toUpperCase()+rest;
      else name+=" "+cap.toUpperCase()+rest;
   }
   return name;
}

//
// ********************************************************************************************
// ******************************************************************************************** 
//
// --------------------------------- element selection ---------------------------------------
function _el(id) {
   return document.getElementById(id);
}

// --------------------------------- element deletion ---------------------------------------
function _del(parEl,chEl) {
   // both parameters are IDs
   _el(parEl).removeChild(_el(chEl));
}

function _wipe(elName) {
   var el=_el(elName);
   while (el.hasChildNodes()) el.removeChild(el.lastChild);
}

// --------------------------------- element creation -------------------------------------
function _newt(el,text,elClass,id) {
   var elmt=document.createElement(el);
   elmt.appendChild(document.createTextNode(text));
   if (elClass!=undefined) elmt.setAttribute("class",elClass);
   if (id!=undefined) elmt.setAttribute("id",id);
   return elmt;
}

function _new(el,elClass,id) {
   var elmt=document.createElement(el);
   if (elClass!=undefined) elmt.setAttribute("class",elClass);
   if (id!=undefined) elmt.setAttribute("id",id);
   return elmt;
}

function _add(parEl,chEl) {
   // parEl is ID; chEl is element
   _el(parEl).appendChild(chEl);
}

function _addEl(parEl,chEl) {
   parEl.appendChild(chEl);
}

function _addBefore(parEl,chEl,befEl) {
   // parEl is ID; chEl is element; befEl is ID
   _el(parEl).insertBefore(chEl,_el(befEl));
}


// --------------------------------- element display ---------------------------------------
function _hide(id) {
   _el(id).style.display="none";
}

function _invis(id) {
   _el(id).style.visibility="hidden";
}

function _show(id) {
   _el(id).style.display="";
   _el(id).style.visibility="";
}

function _enable(id) {
   _el(id).disabled=false;
}

function _disable(id) {
   _el(id).disabled=true;
}

// --------------------------------- element content ------------------------------------
function _write(id,text) {
   _el(id).innerHTML=text;
}

function _addWrite(id,text) {
   _el(id).innerHTML+=text;
}

function _read(id) {
   return _el(id).innerHTML;
}

function _value(id) {
   return _el(id).value;
}

//
// ********************************************************************************************
// ********************************************************************************************
//
// --------------------------------- table object ------------------------------------

// styling tables by multiple classes (e.g. class="t_CENTER t_ITALIC")
// have t_GREEN, t_YELLOW, etc.
//
function myTable(id,elClass) {
   this.id=id;
   if (elClass==undefined) var elClass="";
   this.class=elClass;
   this.table=_new("table",elClass,id);
   this.row="";
   this.cell="";
   this.isRow=false;
   
   // methods
   this.newRow=newRow;
   this.addCell=addCell;
   this.addHeader=addHeader;
   this.addSimpleHeader=addSimpleHeader;
   this.addHeaderSpan=addHeaderSpan;
   this.addRow=addRow;
   this.addCellToRow=addCellToRow;
   this.addTable=addTable;
   this.addCheckCell=addCheckCell;
   
   // method functions
   function addTable(parentID) {
      if (this.isRow) this.addRow();
      _add(parentID,this.table);
   }
   
   function newRow(id,elClass) {
      if (this.isRow) this.addRow();
      this.isRow=true;
      if (id==undefined) this.row=_new("tr");
      else if (elClass==undefined) this.row=_new("tr","",id);
      else this.row=_new("tr",elClass,id);
   }
   
   function addRow() {
      _addEl(this.table,this.row);
      this.isRow=false;
   }
   
   function addCellToRow() {
      _addEl(this.row,this.cell);
   }
   
   function addCell(text,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_newt("td",text,elClass);
      else this.cell=_newt("td",text,elClass,id);
      this.addCellToRow();
   }
   
   function addSimpleHeader(text,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_newt("th",text,elClass);
      else this.cell=_newt("th",text,elClass,id);
      this.addCellToRow();     
   }
   
   function addHeader(text,innerClass,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_new("th",elClass);
      else this.cell=_new("th",elClass,id);
      _addEl(this.cell,_newt("div",text,innerClass));
      this.addCellToRow();     
   }
   
   function addHeaderSpan(colsp,rowsp,text,innerClass,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_new("th",elClass);
      else this.cell=_new("th",elClass,id);
      this.cell.colSpan=colsp;
      this.cell.rowSpan=rowsp;
      _addEl(this.cell,_newt("div",text,innerClass));
      this.addCellToRow();
   }
   
   function addCheckCell(elClass,checkId,checkClass) {
      if (elClass==undefined) var elClass="";
      this.cell=_new("td",elClass);
      
      if (checkId==undefined) var checkId="";
      else if (checkClass==undefined) var checkClass="";
      var chk=_new("input",checkClass,checkId);
      chk.setAttribute("type","checkbox");
      chk.setAttribute("value","1");
      
      _addEl(this.cell,chk);
      this.addCellToRow();
   }   
}
