<?php   
   function _makeNumber($objPHPExcel,$col,$row,$text) {
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
      _border($objPHPExcel,$col.$row);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
   }
   
   function _makeCompany($objPHPExcel,$col,$row,$text) {
      $text=_correct($text);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
      $objPHPExcel->setActiveSheetIndex(0)->getStyle($col.$row)->getFont()->setBold(true);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setWrapText(true);
      _border($objPHPExcel,$col.$row);
   }
   
   function _makeContacts($objPHPExcel,$col,$row,$text) {
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setWrapText(true);
      _border($objPHPExcel,$col.$row);
   }
   
   function _makeDate($objPHPExcel,$col,$row,$text) {
      if ($text=='') $text=' ';
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setWrapText(true);
      _border($objPHPExcel,$col.$row);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
   }
   
   function _makeDummy($objPHPExcel,$col,$row) {
      $text=' ';
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
   }
   
   function _makeRichComment($objPHPExcel,$col,$row,$objRichText) {
      $objPHPExcel->getActiveSheet()->getCell($col.$row)->setValue($objRichText);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setWrapText(true);
      _border($objPHPExcel,$col.$row);
   }
   
   function _makeComment($objPHPExcel,$col,$row,$text) {
      $text=_correct($text);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setWrapText(true);
      _border($objPHPExcel,$col.$row);
   }
   
   function _correct($text) {
      $textParts=explode("*amp*",$text);
      $text=implode("&",$textParts);
      $text=stripslashes($text);
      return $text;
   }
   
   function _border($objPHPExcel,$cell) {
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getTop()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getRight()