<?php
   function _dataCell($table,$text,$width,$isTextBold) {
      if ($isTextBold==false) $table->addCell($width)->addText("$text",array('bold'=>false),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
      else $table->addCell($width)->addText("$text",array('bold'=>true),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   }
   
   function _headerCell($table,$text,$width,$isBold) {
      if ($isBold==false) $table->addCell($width,array('color'=>'808080'))->addText("$text",array('color'=>'999999'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
      else $table->addCell($width,array('color'=>'808080'))->addText("$text",array('bold'=>true,'color'=>'999999'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   }
   
   function _row($table,$text,$header,$isBold,$isTextBold) {
      if ($text!='') {
         $table->addRow();
         _headerCell($table,$header,2550,$isBold);
         _dataCell($table,$text,5700,$isTextBold);
      }
   }
   
      
   // Error reporting
   error_reporting(E_ALL);
   
   require_once '../PHPWord.php';
   $PHPWord = new PHPWord();

   $PHPWord->setDefaultFontName('Calibri');
   $PHPWord->setDefaultFontSize(10);
   
   $projName=$_GET["p"];
   $data=$_POST["data"];
   
   $data=str_replace('*plus*','+',$data);
   $data=str_replace('*amp*','&',$data);
   $data=stripslashes($data);
   
   $fields=explode('__#',"$data");
    
   // Set document properties
   $properties = $PHPWord->getProperties();
   $properties->setCreator('Gateway Baltic'); 
   $properties->setTitle('My title');
   $properties->setDescription('Final report'); 
   $properties->setSubject("$projName");

   $section = $PHPWord->createSection();
   
   $styleTable = array('borderColor'=>'bfbfbf','borderSize'=>6,'cellMargin'=>50);
   $PHPWord->addTableStyle('listTable', $styleTable);
   $styleTable = array('borderColor'=>'808080','borderSize'=>6,'cellMargin'=>50);
   $PHPWord->addTableStyle('companyTable', $styleTable);
   
   //$section->addText("Finland contact results", array('name'=>'Century Gothic','size'=>20,'bold'=>true,'color'=>"808080") );
   //$section->addText("Overview", array('name'=>'Century Gothic','size'=>12,'bold'=>true,'color'=>"808080") );
   //$section->addText("$fields[0]");
   
   $table = $section->addTable('listTable');
   $table->addRow();
   $table->addCell(2900,array('bgColor'=>'d9d9d9'))->addText('Company',array(),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   $table->addCell(2900,array('bgColor'=>'d9d9d9'))->addText('Website',array(),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   for($r=0;$r<count($fields);$r+=12) { 
   	$table->addRow();
   	_dataCell($table,$fields[$r+1],2900,false);
   	_dataCell($table,$fields[$r+4],2900,false);
   }
     
   $decOrder=array('3','0','2','1','9','10');
   $colours=array('76923C','010101','E6E100','FF0000','010101','010101');
   $decText=array('Companies which expressed willingness to meet:','Companies which have not responded yet:','Companies which should be contacted later:','Companies which were not interested in meeting:','Companies which were not successfully contacted:','Companies which were not contacted:');
   
   for($r=0;$r<count($fields);$r+=12) { 
      $section->addPageBreak();
      if ($r==0) {
         if ($fields[0]=='3') $dec=0;
         if ($fields[0]=='0') $dec=1;
         if ($fields[0]=='2') $dec=2;
         if ($fields[0]=='1') $dec=3;
         if ($fields[0]=='9') $dec=4;
         if ($fields[0]=='10') $dec=5;
         $section->addText("$decText[$dec]", array('name'=>'Century Gothic','size'=>16,'bold'=>true,'color'=>"$colours[$dec]") );
      } else {
         if ($fields[$r]!=$decOrder[$dec]) {
            while ($fields[$r]!=$decOrder[$dec]) $dec++;
            $section->addText("$decText[$dec]", array('name'=>'Century Gothic','size'=>16,'bold'=>true,'color'=>"$colours[$dec]") );
         }
      }
      $table = $section->addTable('companyTable');
   	_row($table,$fields[$r+1],"COMPANY NAME",true,true);
   	_row($table,$fields[$r+2],"Address",false,false);
   	_row($table,$fields[$r+3],"Telephone (operator)",false,false);
   	_row($table,$fields[$r+4],"Website",false,false);
   	_row($table,$fields[$r+5],"Turnover",false,false);
   	_row($table,$fields[$r+6],"Employees",false,false);
   	
   	$conCount=(integer) $fields[$r+9];
   	$summary=$fields[$r+10];
   	if ($conCount>0) {   
   	   $contacts=explode('__*',$fields[$r+11]);
   	   _row($table,$contacts[0],"CONTACT PERSON",true,true);
   	   _row($table,$contacts[1],"Position",false,false);
   	   _row($table,$contacts[2],"Mobile",false,false);
   	   _row($table,$contacts[3],"Email",false,false);
   	}
   	
   	_row($table,$fields[$r+7],"DESCRIPTION",true,false);
   	//_row($table,$summary,"FEEDBACK SUMMARY",true,false);
   	
   	if ($fields[$r+8]!='') {
      	$feedback=explode('__*',$fields[$r+8]);
      	$dates=array();
      	$comments=array();
      	for ($a=0;$a<count($feedback);$a++) {
      	   if ($a%2==0) $dates[]="$feedback[$a]";
      	   else $comments[]="$feedback[$a]";
      	}
      	$table->addRow();
      	_headerCell($table,'FEEDBACK',1750,true);
      	$cell = $table->addCell(6500);
   	
      	for ($a=0;$a<count($dates);$a++) {
            $textrun = $cell->createTextRun(array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
            $textrun->addText("$dates[$a]", array('bold'=>true)); 
            $textrun->addText("$comments[$a]");
         }
      }
   } 

   // Save File
   $objWriter = PHPWord_IOFactory::createWriter($PHPWord, 'Word2007');
   $objWriter->save('FinalReport(partial).docx');
   
   echo "OK";
?>