<?php

   function _addCell($objPHPExcel,$col,$row,$text) {
      $text=_correct($text);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue($col.$row,$text);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getAlignment()->setWrapText(true);
      _border($objPHPExcel,$col.$row);
      $objPHPExcel->getActiveSheet()->getStyle($col.$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFFFF');
   }
   
   function _correct($text) {
      $textParts=explode("*plus*",$text);
      $text=implode("+",$textParts);
      $textParts=explode("*amp*",$text);
      $text=implode("&",$textParts);
      $text=stripslashes($text);
      return $text;
   }
   
   function _border($objPHPExcel,$cell) {
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getTop()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);   
   }
   
   // *************************************************************************
   
   ini_set('memory_limit','512M');
   
   $projName=$_GET["p"];
   $dateStr=$_GET["d"];
   $data=$_POST["data"];
   $comps=explode('__#',"$data");
   
   // Error reporting
   error_reporting(E_ALL);
   
   // Include PHPExcel
   require_once '../Classes/PHPExcel.php';
   
   $inputFileName = 'selectionTemplate.xlsx';
   /** Load $inputFileName to a PHPExcel Object  **/
   $objPHPExcel = PHPExcel_IOFactory::load($inputFileName);

   
   // Set document properties
   $objPHPExcel->getProperties() ->setCreator("Gateway Baltic")
   							         ->setLastModifiedBy("Gateway Baltic")
            							->setSubject("$projName")
            							->setDescription("Partner Selection");
   
   //$numnum=count($comps);
   //_addCell($objPHPExcel,'A',1,"$numnum");
   
   // company, address, [location], country, phone, website, turnover, employees, industry, profile, background
   $startrow=7;  // one before start
   $rowNumber=1;
   $cols=array('B','C','D','E','F','G','H','I','J','K');  // 'A' is for rowNumber
   $colNumber=count($cols);
   
   for ($i=0;$i<count($comps);$i+=$colNumber+1) {
      _addCell($objPHPExcel,'A',$startrow+$rowNumber,"$rowNumber");
      $thisRow=$startrow+$rowNumber;
      for ($j=0;$j<$colNumber;$j++) {
         _addCell($objPHPExcel,$cols[$j],$thisRow,$comps[$i+$j]);
      }
      /*
      $loc=str_replace(' ','+',$comps[$i+10]);
      $objPHPExcel->getActiveSheet()->getCell('C'.$thisRow)->getHyperlink()->setUrl('https://maps.google.com/?saddr='.$loc);
      */
      $webStr=$comps[$i+4];
      $webs=explode(',',"$webStr");
      /* $objPHPExcel->getActiveSheet()->getCell('F'.$thisRow)->getHyperlink()->setUrl('http://'.$webs[0]); */
      $rowNumber++;
      $objPHPExcel->getActiveSheet()->getStyle('L'.$thisRow.':T'.$thisRow)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFFFF');
   }
   
   for ($i=0;$i<10;$i++) {
      $thisRow++;
      $objPHPExcel->getActiveSheet()->getStyle('A'.$thisRow.':T'.$thisRow)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFFFF');
   }
   
   $country=$comps[2];
   if ($country=='United Kingdom') $country='the United Kingdom';
   $objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2','PARTNER attraction in '.$country);
   $objPHPExcel->getActiveSheet()->getStyle('B2')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFFFF');
     
   $objPHPExcel->getActiveSheet()->setTitle('Partner selection');
   $objPHPExcel->setActiveSheetIndex(0);
   
   // Save Excel 2007 file
   $projParts=explode(" ",$projName);
   $fileName=implode("_",$projParts);
   $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
   $objWriter->save($fileName.'_Partner_Selection_'.$dateStr.'.xlsx');
   
   echo "OK";
?>