<?php
   function _dataCell($table,$text,$width,$isTextBold) {
      if ($isTextBold==false) $table->addCell($width)->addText("$text",array('bold'=>false,'color'=>'5C5C5C'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
      else $table->addCell($width)->addText("$text",array('bold'=>true,'color'=>'5C5C5C'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   }
   function _listCell($table,$text,$width,$isTextBold,$color,$txtColor) {
      if ($isTextBold==false) $table->addCell($width,array('bgColor'=>$color))->addText("$text",array('bold'=>false,'color'=>$txtColor),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
      else $table->addCell($width,array('bgColor'=>$color))->addText("$text",array('bold'=>true, 'color'=>$txtColor),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   }

   function _headerCell($table,$text,$width,$isBold) {
      if ($isBold==false) $table->addCell($width,array('bgColor'=>'F2F2F2'))->addText("$text",array('color'=>'5C5C5C'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
      else $table->addCell($width,array('bgColor'=>'F2F2F2'))->addText("$text",array('bold'=>true,'color'=>'5C5C5C'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   }

   function _companyCell($table,$text,$width,$isBold,$bgColor,$txtColor) {
      if ($isBold==false) $table->addCell($width,array('bgColor'=>$bgColor,'valign'=>'bottom'))->addText("$text",array('color'=>$txtColor,'bold'=>false,),array('spaceBefore'=>250,'spaceAfter'=>250,'spacing'=>0));
      else $table->addCell($width,array('bgColor'=>$bgColor,'valign'=>'bottom'))->addText("$text",array('bold'=>false,'color'=>$txtColor),array('spaceBefore'=>250,'spaceAfter'=>250,'spacing'=>0));
   }

   function _row($table,$text,$header,$isBold,$isTextBold) {
      if ($text!='') {
         $table->addRow();
         _headerCell($table,$header,2550,$isBold);
         _dataCell($table,$text,5700,$isTextBold);
      }
   }
   function _company_row($table,$text,$header,$isBold,$isTextBold,$bgColor,$txtColor) {
      if ($text!='') {
         $table->addRow();
         _companyCell($table,$header,2550,$isBold,$bgColor,$txtColor);
         _companyCell($table,$text,5700,$isTextBold,$bgColor,$txtColor);
      }
   }


   // Error reporting
   error_reporting(E_ALL);

   require_once '../PHPWord.php';
   $PHPWord = new PHPWord();

   $PHPWord->setDefaultFontName('Avenir');
   $PHPWord->setDefaultFontSize(10);

   $projName=$_GET["p"];
   $data=$_POST["data"];

   /* $myfile = fopen("final_log.txt", "w");
   //for($r=0;$r<count($fields);$r+=12) {
     $txt = $_POST["data"];
     fwrite($myfile, $txt);
   //}
   fclose($myfile); */

   $data=str_replace('*plus*','+',$data);
   $data=str_replace('*amp*','&',$data);

   $data=stripslashes($data);

   $fields=explode('__#',"$data");

    // Set document properties
   $properties = $PHPWord->getProperties();
   $properties->setCreator('Gateway Baltic');
   $properties->setTitle('My title');
   $properties->setDescription('Final report');
   $properties->setSubject("$projName");

   $section = $PHPWord->createSection();

   $styleTable = array('borderColor'=>'000000','borderSize'=>'1','cellMargin'=>50);
   $PHPWord->addTableStyle('listTable', $styleTable);
   $styleTable = array('borderColor'=>'808080','borderSize'=>'none','cellMargin'=>50);
   $PHPWord->addTableStyle('companyTable', $styleTable);

   //$section->addText("Finland contact results", array('name'=>'Century Gothic','size'=>20,'bold'=>true,'color'=>"808080") );
   //$section->addText("Overview", array('name'=>'Century Gothic','size'=>12,'bold'=>true,'color'=>"808080") );
   //$section->addText("$fields[0]");

   $table = $section->addTable('listTable');
   $table->addRow();
   $table->addCell(2900,array('bgColor'=>'FFFFFF'))->addText('Company',array('color'=>'000000','bold'=>true),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   $table->addCell(2900,array('bgColor'=>'FFFFFF'))->addText('Website',array('color'=>'000000','bold'=>true),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   /* $table->addRow();
   $table->addCell(2900,array('bgColor'=>'D2CEC3'))->addText('',array('color'=>'767573'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
   $table->addCell(2900,array('bgColor'=>'D2CEC3'))->addText('',array('color'=>'767573'),array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0)); */
   for($r=0;$r<count($fields);$r+=12) {
      $colours=array('839C00','FFFFFF','FFC000','BFBFBF','FFFFFF','FFFFFF');
      $tt = array('000000', 'FFFFFF');
         if ($fields[$r]=='3') { $fieldColor = $colours[0]; $txtColor = $tt[0]; }
         if ($fields[$r]=='0') { $fieldColor = $colours[1]; $txtColor = $tt[0]; }
         if ($fields[$r]=='2') { $fieldColor = $colours[2]; $txtColor = $tt[0]; }
         if ($fields[$r]=='1') { $fieldColor = $colours[3]; $txtColor = $tt[0]; }
         if ($fields[$r]=='9') { $fieldColor = $colours[4]; $txtColor = $tt[0]; }
         if ($fields[$r]=='10') { $fieldColor = $colours[5]; $txtColor = $tt[0]; }
      $table->addRow();
      _listCell($table,$fields[$r+1],2900,false,$fieldColor,$txtColor);
      _listCell($table,$fields[$r+4],2900,false,$fieldColor,$txtColor);
   }

   $decOrder=array('3','0','2','1','9','10');
   $colours=array('839C00','FFFFFF','FFC000','BFBFBF','FFFFFF','FFFFFF');
   $decText=array('COMPANIES WHICH EXPRESSED WILLINGNESS TO MEET:','COMPANIES WHICH HAVE NOT RESPONDED YET:','COMPANIES WHICH SHOULD BE CONTACTED LATER:','COMPANIES WHICH WERE NOT INTERESTED IN MEETING:','COMPANIES WHICH WERE NOT SUCCESSFULLY CONTACTED:','COMPANIES WHICH WERE NOT CONTACTED:');

   for($r=0;$r<count($fields);$r+=12) {
      $section->addPageBreak();
      if ($r==0) {
         if ($fields[0]=='3') { $dec=0; $coll = "839C00"; }
         if ($fields[0]=='0') { $dec=1; $coll = "BFBFBF"; }
         if ($fields[0]=='2') { $dec=2; $coll = "FFC000"; }
         if ($fields[0]=='1') { $dec=3; $coll = "BFBFBF"; }
         if ($fields[0]=='9') { $dec=4; $coll = "BFBFBF"; }
         if ($fields[0]=='10') { $dec=5; $coll = "BFBFBF"; }
         $section->addText("$decText[$dec]", array('name'=>'Avenir','size'=>16,'bold'=>false,'color'=>"$coll") );
         $section->addText('');
      } else {
         if ($fields[$r]!=$decOrder[$dec]) {
            while ($fields[$r]!=$decOrder[$dec]) $dec++;
            if ($dec == 0) $coll = "839C00";
            if ($dec == 1) $coll = "BFBFBF";
            if ($dec == 2) $coll = "FFC000";
            if ($dec == 3) $coll = "BFBFBF";
            if ($dec == 4) $coll = "BFBFBF";
            if ($dec == 5) $coll = "BFBFBF";
            $section->addText("$decText[$dec]", array('name'=>'Avenir','size'=>16,'bold'=>false,'color'=>"$coll") );
            $section->addText('');
         }
      }
      $table = $section->addTable('companyTable');
      if ($dec == 1 || $dec == 2)
        _company_row($table,$fields[$r+1],"Company Name",true,true,$coll,"000000");
      else
         _company_row($table,$fields[$r+1],"Company Name",true,true,$coll,"000000");
      _row($table,$fields[$r+2],"Address",false,false);
      _row($table,$fields[$r+3],"Telephone (operator)",false,false);
      _row($table,$fields[$r+4],"Website",false,false);
      _row($table,$fields[$r+5],"Turnover",false,false);
      _row($table,$fields[$r+6],"Employees",false,false);

      $conCount=(integer) $fields[$r+9];
      $summary=$fields[$r+10];
      if ($conCount>0) {
         $contacts=explode('__*',$fields[$r+11]);
         _row($table,$contacts[0],"Contact Person",false,false);
         _row($table,$contacts[1],"Position",false,false);
         _row($table,$contacts[2],"Mobile",false,false);
         _row($table,$contacts[3],"Email",false,false);
      }

      _row($table,$fields[$r+7],"Description",false,false);
      //_row($table,$summary,"FEEDBACK SUMMARY",true,false);

      if ($fields[$r+8]!='') {
         $feedback=explode('__*',$fields[$r+8]);
         $dates=array();
         $comments=array();
         for ($a=0;$a<count($feedback);$a++) {
            if ($a%2==0) $dates[]="$feedback[$a]";
            else $comments[]="$feedback[$a]";
         }
         $table->addRow();
         _headerCell($table,'Feedback',1750,false);
         $cell = $table->addCell(6500);

         for ($a=0;$a<count($dates);$a++) {
            $textrun = $cell->createTextRun(array('spaceBefore'=>0,'spaceAfter'=>0,'spacing'=>0));
            $textrun->addText("$dates[$a]", array('bold'=>true,'color'=>'5C5C5C'));
            $textrun->addText("$comments[$a]",array('color'=>'5C5C5C'));
         }
      }
   }

   // Save File
   $objWriter = PHPWord_IOFactory::createWriter($PHPWord, 'Word2007');
   $objWriter->save('FinalReport(partial).docx');

   echo json_encode(["status"=>'OK', "file"=>'FinalReport(partial).docx']);
?>
