// ---------------------------------------- loading functions ---------------------------------------       
function _newLoad() {
   var found=NOTFOUND;
   for (var i=0;i<actionList.length && found==NOTFOUND;i++) {
      if (actionList[i].status==WAITING) found=i;
   }
   if (found!=NOTFOUND) {
      isLoading++;
      switch (actionList[found].type) {
         case ACTION_LOADPROJECT:
             _loadProject(found);
             break;
         case ACTION_LOADCOMPANY:
            _loadCompany(found);
            break;
      }
   }
}

function _loadProject(indx) {
   var xmlhttp;
   if (window.XMLHttpRequest) xmlhttp=new XMLHttpRequest();
   else xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");

   xmlhttp.onreadystatechange=function() {
      if (xmlhttp.readyState==4 && xmlhttp.status==200) {
         var data=JSON.parse(xmlhttp.responseText);
         // projectID,proj,indx,loadedFiles,noteText,contact,email,assignedto,coordinator, ...companies...
         //     0       1    2       3         4        5       6     7           8               9+
         var proj=_int(data[1]);
         var indx=_int(data[2]);
         actionList[indx].endAction(indx);
         
         projects[proj].profileFile=data[2][0];
         projects[proj].meetingPlanFile=data[2][1];
         projects[proj].reportFile=data[2][2];
         projects[proj].contact=data[4];
         projects[proj].email=data[5];
         projects[proj].assignedto=data[6];
         projects[proj].coordinator=data[7];
         
         projects[proj].processBlogName();            // not implemented yet
         projects[proj].processNoteText(data[3]);     // not implemented yet
         
         var ind;
         for (var i=9;i<data.length;i++) {
            projects[proj].companyIdList.push(data[i][0]);
            projects[proj].companyNameList.push(data[i][1]);
            projects[proj].companies.push(new company(data[i][0]));
            ind=actionList.push(new action(ACTION_LOADCOMPANY,proj,i-9));
            actionList[ind-1].startAction();
         }
      }
   }
   actionList[indx].processAction();
   var proj=actionList[indx].project;
   xmlhttp.open("GET","LoadProject.php?proj="+proj+"&id="+projects[proj].id+"&indx="+indx,true);
   xmlhttp.send();
}

function _loadCompany(indx) {
   var xmlhttp;
   if (window.XMLHttpRequest) xmlhttp=new XMLHttpRequest();
   else xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");

   xmlhttp.onreadystatechange=function() {
      if (xmlhttp.readyState==4 && xmlhttp.status==200) {
         var data=JSON.parse(xmlhttp.responseText);
         // array("$proj","$comp","$indx","$name",$acts,$relations,$categoryTags,"$website","$phone", "$address","$turnover",
         //          0        1       2       3      4       5           6            7         8         9          10
         //       "$employees","$industry","$background","$country","$created",$contacts,"$compId","$assignedto" (was + "$project")
         //            11           12           13          14         15         16       17           18          19
         var proj=_int(data[0]);
         var comp=_int(data[1]);
         var indx=_int(data[2]);
         if (data[3]=="CLIENTDETAILS-NOTCOMPANY") projects[proj].companyNameList[comp]="CLIENTDETAILS-NOTCOMPANY";
         projects[proj].companies[comp].name=data[3];
         //projects[proj].companies[comp].project=proj;
         projects[proj].companies[comp].website=data[7];
         projects[proj].companies[comp].phone=data[8];
         projects[proj].companies[comp].address=data[9];
         projects[proj].companies[comp].turnover=data[10];
         projects[proj].companies[comp].employees=data[11];
         projects[proj].companies[comp].industry=data[12];
         projects[proj].companies[comp].background=data[13];
         projects[proj].companies[comp].country=data[14];
         projects[proj].companies[comp].created=new myDate(data[15]);
         projects[proj].companies[comp].assignedto=data[18];
         projects[proj].companies[comp].project=projects[proj].name;

         projects[proj].companies[comp].buildRelations(data[5]);
         projects[proj].companies[comp].buildContacts(data[16]);
         projects[proj].companies[comp].buildCategoryTags(data[6]);
         projects[proj].companies[comp].buildActivities(data[4]);
         projects[proj].companies[comp].processActivities();
         //
         actionList[indx].endAction(indx);
      }
   }
   actionList[indx].processAction();
   var proj=actionList[indx].project;
   var comp=actionList[indx].company;
   var id=projects[proj].companyIdList[comp];
   xmlhttp.open("GET","LoadCompany.php?proj="+proj+"&comp="+comp+"&id="+id+"&indx="+indx+"&projName="+projects[proj].name,true);
   xmlhttp.send();
}