// ------------------------------- action list object -----------------------------------

var WAITING=0;
var SENT=1;
var RECEIVED=2;
var ACTION_LOADPROJECT=0;
var ACTION_LOADCOMPANY=1;
var ACTION_SENDEMAIL=2;

function action(type,param1,param2) {
   this.status=WAITING;
   this.type=type;
   if (type==ACTION_SENDEMAIL) {
      this.project=NOTSET;
      this.company=NOTSET;
      // + email stuff
   } else {
      if (param2==undefined) var param2=NOTSET;
      this.project=param1;
      this.company=param2;
      // + blank email stuff?
   }

   // methods
   this.startAction=startAction;
   this.processAction=processAction;
   this.endAction=endAction;

   // method functions
   function startAction() {
      switch (this.type) {
         case ACTION_LOADPROJECT:
            _addWrite("infoBox","<h6 class='close' id='load"+this.project+"'>Waiting to load "+projects[this.project].name+"...</h6>");
            break;
         case ACTION_LOADCOMPANY:
            var name=projects[this.project].companyNameList[this.company];
            _addWrite("infoBox","<h6 class='close' id='load"+_combine(this.project,this.company)+"'>Waiting to load "+name+"...</h6>");
            break;
      }
      if (isLoading<MAXLOADING) _newLoad();
      //else alert(isLoading);
   }
   
   function processAction() {
      switch (this.type) {
         case ACTION_LOADPROJECT:
            _write("load"+this.project,"Loading "+projects[this.project].name+"...");
            break;
         case ACTION_LOADCOMPANY:
            var name=projects[this.project].companyNameList[this.company];
            _write("load"+_combine(this.project,this.company),"Loading "+name+"...");
            break;
      }
      this.status=SENT;
   } 
   
   function endAction(indx) {
      switch (this.type) {
         case ACTION_LOADPROJECT:
            _del("infoBox","load"+this.project);
            break;
         case ACTION_LOADCOMPANY:
            _del("infoBox","load"+_combine(this.project,this.company));
            break;
      }
      this.status=RECEIVED;
      if (--isLoading==0) {
         // wipe actionList!
         actionList=new Array();
      } else if (isLoading<MAXLOADING) _newLoad();
      
      // check to see if project-company load is finished and enable view for project if so
      if (this.type==ACTION_LOADCOMPANY) {
         var found=false;
         for (var i=0;i<actionList.length && !found;i++) {
            if (actionList[i].project==this.project && actionList[i].status!=RECEIVED) found=true;
         }
         if (!found) {
            // mark project as loaded
            projects[this.project].isLoaded=true;
            // create option in project menu
            settings.addProject(this.project);
            settings.addProjectSummary(this.project);
            //
            var txt="";
            for (var i=0;i<projects[this.project].companies.length;i++) {
               if (projects[this.project].companies[i].subProjects.length>0) {
                  if (projects[this.project].companies[i].subProjects[0].status[0]==GREEN) {
                     txt+=projects[this.project].companies[i].name+", ";
                  }
               }
            }
            //alert(txt);
            // enable overview and progress if not already in those menus
            if (settings.rootMenu==menuLIST) {
               _el("rootMenuOverview").setAttribute("class","menu");
               _el("rootMenuProgress").setAttribute("class","menu");
               if (isLoading==0) _goToMenu(menuPROGRESS);
            }
         }
      }
   }
}