// ------------------------------- activity object ----------------------------------------

var CALL=73;
var NOTE=3;

var _SHOW=0;
var _EXPAND=1;
var _HIDE=2;      // for private & braces
var _HIDESYSTEM=3;   // for braces ( {con=}, {no1}, {no2}


// $acts[]=array("$actId","$actName",$actType,"COMPANYROOTPAGE" or $contactId,"$actCreated","$actDate","creatorID","creatorName");

function activity(data) {
   this.id=data[0];
   this.date=new myDate(_fixCommentDate(data[4],data[5]));     // not implemented yet
   this.comment=data[1];
   this.commentText="";
   this.privateText="";
   this.type=data[2];
   if (data[3]!="COMPANYROOTPAGE") {
      this.isContactEntry=true;
      this.contact=_findContactFromId(data[3]);
   } else {
      this.isContactEntry=false;
      this.contact=NOTSET;
   }
   this.creatorId=data[6];
   this.creatorName=data[7];
   //
   this.no1=false;
   this.no2=false;
   this.isCon=false;
   this.conRef=NOTSET;
   this.projectTags=new Array();
   this.isFirst=false;
   this.isPrivate=false;
   this.isPlus=false;
   this.isInvalid=false;
   this.isConfirmation=false;
   this.meetingDate=new myDate();
   this.meetingTime=NOTSET;
   this.decision=NOTSET;
   
   // methods
   this.process=process;
   this.convertComment=convertComment;
   this.getCommentText=getCommentText;
   this.processCodes=processCodes;
   this.checkIsProjectAndSub=checkIsProjectAndSub;
   this.checkValid=checkValid;
   this.update=update;
   this.getPrivateText=getPrivateText;
   
   // method functions
   function update(data) {
      // var data=[updateObj.entryId,updateObj.comment,updateObj.entryType,updateObj.targetId,updateObj.date,updateObj.date, "***creatorID***", updateObj.caller];
      this.date=new myDate(_fixCommentDate(data[4],data[5]));     // not implemented yet
      this.comment=data[1];
      this.commentText="";
      this.privateText="";
      this.type=data[2];
      if (data[3]!="COMPANYROOTPAGE") {
         this.isContactEntry=true;
         this.contact=_findContactFromId(data[3]);
      } else {
         this.isContactEntry=false;
         this.contact=NOTSET;
      }
      this.creatorId=data[6];
      this.creatorName=data[7];
      //
      this.no1=false;
      this.no2=false;
      this.isCon=false;
      this.conRef=NOTSET;
      this.projectTags=new Array();
      this.isFirst=false;
      this.isPrivate=false;
      this.isPlus=false;
      this.isInvalid=false;
      this.isConfirmation=false;
      this.meetingDate=new myDate();
      this.meetingTime=NOTSET;
      this.decision=NOTSET;
   }
   
   function checkValid(dateFrom,subObj,searchCON) {
      var isValid=false;
      if (this.date.dateNumber()>=dateFrom) {
         if (!this.isPrivate || searchCON) {
            if (this.checkIsProjectAndSub(subObj)) {
               if (this.isContactEntry && !searchCON) {
                  for (var i=0;i<subObj.con.length && !isValid;i++) {
                     if (this.contact==subObj.company.contactRelations[subObj.con[i]]) isValid=true;
                  }
               } else isValid=true;
            }
         }
      }
      return isValid;
   }
   
   function checkIsProjectAndSub(subObj) {
      var foundThis=false;
      var foundOther=false;
      for (var i=0;i<this.projectTags.length && !foundThis;i++) {
         if (this.projectTags[i].project==UNKNOWN) {
            foundOther=true;
         } else {
            //alert(subObj.company.projectRelations[this.projectTags[i].project]);
            if (this.projectTags[i].subProject==undefined) {
               //alert("found undefined subProject tag for projectTag item in "+subObj.company.name);
            }
            if (_icmp(subObj.company.projectRelations[this.projectTags[i].project],subObj.company.project)) {
               if (!subObj.company.isMultiple || _icmp(this.projectTags[i].subProject,subObj.name)) foundThis=true;
               else foundOther=true;
            } else foundOther=true;
         }
      }
      return (foundThis) ?true :!foundOther;
   }
   
   function process(compObj,actNum) {
      // called by company.buildActivities
      var tagList=_getTagList(this.comment);
      this.decision=NOTSET;
      for (var i=0;i<tagList.length;i++) {
         switch (tagList[i]) {
            case "1":
               this.isFirst=true;
               break;
            case "r":
            case "red":
               this.decision=RED;
               break;
            case "g":
            case "green":
               this.decision=GREEN;
               break;
            case "y":
            case "yellow":
               this.decision=YELLOW;
               break;
            case "!":
            case "*":
               this.isPrivate=true;
               break;
            case "invalid":
               this.isInvalid=true;
               break;
            case "+":
               this.isPlus=true;
               break;
            default:
               this.projectTags.push(new projectTag(tagList[i],compObj,actNum));
         }
      }
      //if (compObj.name=="Realbygg") alert(this.comment+" ... "+this.isFirst+" / "+this.decision);
      this.comment=_tidyText(this.comment);
      this.commentText=_tidyText(this.getCommentText());
      this.privateText=_tidyText(this.getPrivateText());
      
      var conName=this.processCodes(compObj);
      if (this.isCon) {
         this.conRef=_findContactFromName(conName,compObj.contactRelations);
         if (this.conRef==NOTFOUND) {
            // create new contact
            // $contacts[]=array("$contactId", "$contactName","$contactTitle","$contactPhone","$contactMobile","$contactEmail",
            // "$contactWebsite","$contactCountry", "$contactAssigned", $contactRelated,);
            var conData=["NOTINSOLVE",_capitalise(conName),[compObj.project]];
            compObj.contactRelations.push(contacts.push(new contact(conData))-1);
            this.conRef=_findContactFromName(conName,compObj.contactRelations);
            //alert(this.conRef+" ... "+compObj.contactRelations.length);
         }
      }
   }  
   
   function processCodes(compObj) {
      // **************************** should generate an error if no2 and con= is found together ************************************
      var conName="";
      var codeFound;
      var text=_tidyText(_hideBraces(this.commentText));
      do {
         //if (compObj.name=="Avian Adventures") alert("|"+text+"|");
         codeFound=false;
         if (text.slice(0,3)=="no1" || text.slice(0,3)=="no2") {
            //if (compObj.name=="Avian Adventures") alert("no12");
            if (text.slice(0,3)=="no1") this.no1=true;
            else this.no2=true;
            text=text.slice(3);
            codeFound=true;
         } else {
            if (text.slice(0,4)=="con=") {
               //if (compObj.name=="Avian Adventures") alert("con=");
               var retData=_getConName(text);
               conName=retData[0];
               this.isCon=true;
               codeFound=true;
               text=retData[1];
            }
         }
      } while (codeFound);
      
      text=this.privateText;
      if (text.indexOf("no1")!=NOTFOUND) this.no1=true;
      if (text.indexOf("no2")!=NOTFOUND) this.no2=true;
      
      if (conName=="") {
         if (text.indexOf("con=")!=NOTFOUND) {
            var pos=text.indexOf("con=");
            text=text.slice(pos);
            var retData=_getConName(text);
            conName=retData[0];
            this.isCon=true;
            codeFound=true;
         }
      }
      return conName;
   }
   
   function getCommentText() {
      var text=this.comment;
      var start,end;
      while (text.indexOf("[")!=NOTFOUND) {
         start=text.indexOf("[");
         end=text.indexOf("]");
         if (end==NOTFOUND) end=text.length-1;
         text=text.slice(0,start)+text.slice(end+1);
      }
      return text;
   }
   
   function getPrivateText() {
      var text=this.comment;
      var pText="";
      var start,end;
      while (text.indexOf("{")!=NOTFOUND) {
         start=text.indexOf("{");
         end=text.indexOf("}");
         if (end==NOTFOUND) end=text.length;
         if (pText!="") pText+="; ";
         pText+=text.slice(start+1,end);
         text=text.slice(0,start)+text.slice(end+1);
      }
      return pText;
   }
   
   function convertComment(compObj,convertNO12,convertCON,convertPrivate,convertBraces) {
      // return comment text according to specifications (passed as CONVERT_ constants)
      
      // viewer (_EXPAND/(_SHOW),_EXPAND,_HIDE/SHOW,_HIDESYSTEM) --- this could be changed according in viewer options
      // mouseover (SHOW,_EXPAND,_SHOW)
      // client ((_SHOW),_EXPAND,_HIDE, _HIDE)
      // final (_EXPAND,_EXPAND,_HIDE, _HIDE)
      // ********* add show tags options later ************
      var text=this.commentText;
      //var text=this.comment;
      
      var pos;
      
      switch (convertBraces) {
         case _HIDE:
            text=_hideBraces(text);
            break;
         case _HIDESYSTEM:  
            pos=text.indexOf("{no1}");
            if (pos==NOTFOUND) pos=text.indexOf("{no2}");
            if (pos!=NOTFOUND) text=text.slice(0,pos)+text.slice(pos+5);   
            pos=text.indexOf("{con=");
            if (pos!=NOTFOUND) {
               var tmpText=text.slice(pos);
               var endPos=tmpText.indexOf("}");
               if (endPos==NOTFOUND) endPos=tmpText.length;
               text=text.slice(0,pos)+tmpText.slice(endPos+1);   
            }
            break;
      }
      if (convertNO12==_EXPAND) {
         if (this.no1 && text.indexOf("no1")!=NOTFOUND) {
            pos=text.indexOf("no1");
            text=text.slice(0,pos)+substitutions[0]+_addPunctuation(text.slice(pos+3),false);
         }
         if (this.no2 && text.indexOf("no2")!=NOTFOUND) {
            pos=text.indexOf("no2");
            if (this.isContactEntry) var substText=contacts[this.contact].name;
            else var substText=substitutions[1];
            substText+=substitutions[2];
            text=text.slice(0,pos)+substText+_addPunctuation(text.slice(pos+3),false);
         }
      }
      if (this.isCon && convertCON==_EXPAND && this.privateText.indexOf("con=")==NOTFOUND) {
         pos=text.indexOf("con=");
         var retData=_getConName(text.slice(pos));
         text=text.slice(0,pos)+substitutions[3]+contacts[compObj.contactRelations[this.conRef]].name+_addPunctuation(retData[1],true);
      }
      if (this.isPrivate) {
      }
      return text;
   }
}