// ------------------------------- company object ----------------------------------------
function company(id) {
   this.subProjects=new Array();
   this.id=id;
   this.name="";
   this.address="";
   this.website="";
   this.email="";
   this.phone="";
   this.profile="";
   this.industry="";
   this.project="";
   this.background="";
   this.turnover="";
   this.employees="";
   this.assignedto="";
   this.country="";
   this.activities=new Array();
   this.categoryTags=new Array();
   this.contactRelations=new Array();
   this.projectRelations=new Array();
   this.created=new myDate();
   this.status=[NOTSET,NOTSET];
   this.stats=new Array();
   this.isMultiple=false;
   this.activeProjects=new Array();    // if .length>1 || .isMultiple, then need to tag in ProjectMaster
   
   // methods
   this.loadData=loadData;
   this.calculateStats=calculateStats;
   this.addSubProject=addSubProject;
   this.buildRelations=buildRelations;
   this.buildContacts=buildContacts;
   this.buildActivities=buildActivities;
   this.buildCategoryTags=buildCategoryTags;
   this.processActivities=processActivities;
   this.getMultipleDecision=getMultipleDecision;
   this.getMultipleDecisionForTable=getMultipleDecisionForTable;
   this.sortActivities=sortActivities;
   this.getCompanyTableEntry=getCompanyTableEntry;
   this.getCompanyTitleText=getCompanyTitleText;
   this.getProjectRelationsList=getProjectRelationsList;
   this.userAddModifyActivity=userAddModifyActivity;
   
   // method functions
   function getProjectRelationsList() {
      var listText="";
      for (var i=0;i<this.projectRelations.length;i++) {
         if (this.projectRelations[i]!=this.project) {
            if (listText!="") listText+=", ";
            listText+=this.projectRelations[i];
         }
      }
      return listText;
   }
   
   function getCompanyTitleText(convertNO12,convertCON,convertPrivate) {
      // move to subproject object, along with getTableEntry!!
   }
   
   function getCompanyTableEntry() {
      var retData=new Array();
      if (this.subProjects.length>0) {
         retData.push(this.name);
         retData.push(this.subProjects.length);
         if (this.subProjects.length>1) retData.push(this.getMultipleDecisionForTable());
         else retData.push("");
         for (var i=0;i<this.subProjects.length;i++) {
            var subp=this.subProjects[i];
            switch (subp.status[0]) {
               case RED:
                  var rowColour="rowSelectedRED";
                  break;
               case YELLOW:
                  var rowColour="rowSelectedYELLOW";
                  break;
               case GREEN:
                  var rowColour="rowSelectedGREEN";
                  break;
               default:
                  var rowColour="rowSelectedWHITE";
            }
            var cont=subp.getContactList(true);
            if (subp.entry1[0]==NOTSET) {
               var date1="";
               var com1="";
            } else {
               var date1=this.activities[subp.entry1[0]].date.reportDate();
               var com1=this.activities[subp.entry1[0]].convertComment(this,_EXPAND,_EXPAND,_HIDE,_HIDE);
            }
            if (subp.entry2[0]==NOTSET) {
               var date2="";
               var com2="";
            } else {
               var date2=this.activities[subp.entry2[0]].date.reportDate();
               var com2=this.activities[subp.entry2[0]].convertComment(this,_EXPAND,_EXPAND,_HIDE,_HIDE);
            }
            retData.push(rowColour);
            retData.push(cont);
            retData.push(date1);
            retData.push(com1);
            retData.push(date2);
            retData.push(com2);
            if (subp.isSubProject) retData.push(subp.name);
            else retData.push("");
         }
      } else {
         retData=[this.name,1,"rowSelectedWHITE","rowSelectedWHITE","","","","","",""];
      }
      //alert(retData.toSource());
      return retData;
   }
     
   function loadData() {
      // (re)loads company data
      // need parameters to tell method what to do when finished??
      // and how to display progress?
   }
   
   function addSubProject(name,isSubProject,start,end) {
      // start,end=NOTSET if 1st reference is not a start/end tag; name="" if not subProject
      if (isSubProject) this.isMultiple=true;
      return this.subProjects.push(new subProject(this,name,isSubProject,start,end))-1;
   }
   
   function calculateStats(dateFrom) {
      // compute data for this.stats[NOW] or this.stats[OLD] (depending on dateFrom)
   }
   
   function buildRelations(data) {
      // puts blog relations into an array
      for (var i=0;i<data.length;i++) this.projectRelations.push(data[i]);
   }
   
   function buildContacts(data) {
      // $contacts[]=array("$contactId", "$contactName","$contactTitle","$contactPhone","$contactMobile","$contactEmail",
      // "$contactWebsite","$contactCountry", "$contactAssigned", $contactRelated,);
      //
      for (var i=0;i<data.length;i++) {
         var found=_findContactFromId(data[i][0]);
         if (found==NOTFOUND) found=contacts.push(new contact(data[i]))-1;
         this.contactRelations.push(found);
      }
   }
   
   function buildCategoryTags(data) {
      // processes category tags
      for (var i=0;i<data.length;i++) this.categoryTags.push(data[i]);
   }

   function buildActivities(data) {
      for (var i=0;i<data.length;i++) this.activities.push(new activity(data[i]));
      if (data.length>1) this.sortActivities();
      for (var i=0;i<data.length;i++) this.activities[i].process(this,i);
   }
   
   function processActivities(dateFrom) {
      // for current => undefined; calculates stats and errors at the same time 
      if (dateFrom==undefined) dateFrom=0;
      if (this.activities.length>0) {
         //
         // check to see if any subprojects have been created!
         if (this.subProjects.length==0) this.addSubProject("",false,this.activities.length-1,0);
         //
         // process for each subproject
         for (var i=0;i<this.subProjects.length;i++) {
            this.subProjects[i].processActivities(dateFrom);
         }
      } else {
         // blank company
      }
   }
   
   function userAddModifyActivity(updateObj) {
      // .type  .action  .targetId  .entryType  .date  .comment  .entryId  .actNumber .caller
      // $acts[]=array("$actId","$actName",$actType,"COMPANYROOTPAGE" or $contactId,"$actCreated","$actDate","creatorID","creatorName");
      var data=[updateObj.entryId,updateObj.comment,updateObj.entryType,updateObj.targetId,updateObj.date,updateObj.date, "***creatorID***", updateObj.caller];
      if (updateObj.type==UPDATE_COMPANY) data[3]="COMPANYROOTPAGE";
      
      if (updateObj.action==UPDATE_EDITACTIVITY) {
         this.activities[updateObj.actNumber].update(data);
      } else {
         this.activities.push(new activity(data));
      }
      this.subProjects=new Array();
      this.sortActivities();
      for (var i=0;i<this.activities.length;i++) {
         this.activities[i].process(this,i);
         //alert(this.activities[i].comment+" ... "+this.activities[i].date.date);
      }
      this.processActivities();
      //alert("changed internal records: "+updateObj.comment);
      // need to update progress report (done??)
   }
   
   function sortActivities() {
      // sort activities by myDate.dateNumber
      // bubble sort!
      var swapped;
      var swapTemp;
      do {
         swapped=false;
         for (var i=0;i<this.activities.length-1;i++) {
            if (this.activities[i+1].date.dateNumber()>this.activities[i].date.dateNumber()) {
               swapTemp=this.activities[i];
               this.activities[i]=this.activities[i+1];
               this.activities[i+1]=swapTemp;
               swapped=true;
            }
         }
      } while (swapped);
      if (this.name=="--------------") {
         var txt="";
         for (var i=0;i<this.activities.length;i++) {
            txt+=this.activities[i].date.date+" "+this.activities[i].date.dateNumber()+" "+this.activities[i].comment+"\n";
            //alert(this.activities[i].date.toSource());
         }
         alert(txt);
      }
   }
   
   function getMultipleDecisionForTable() {
      var colRank=["rowSelectedRED","rowSelectedWHITE","rowSelectedYELLOW","rowSelectedGREEN"]
      var retColour=-1;
      var tmpCol=-1;
      for (var i=0;i<this.subProjects.length;i++) {
         var subp=this.subProjects[i];
         switch (subp.status[0]) {
            case RED:
               tmpCol=0;
               break;
            case YELLOW:
               tmpCol=2;
               break;
            case GREEN:
               tmpCol=3;
               break;
            default:
               tmpCol=1;
         }
         if (tmpCol>retColour) retColour=tmpCol;
      }
      return colRank[retColour];
   }
   
   function getMultipleDecision() {
      var decRank=[RED,ONFIRSTCALL,NODECISION,YELLOW,GREEN];
      var retDecision=-1;
      var tmpDec=-1;
      for (var i=0;i<this.subProjects.length;i++) {
         var subp=this.subProjects[i];
         switch (subp.status[0]) {
            case RED:
               tmpDec=0;
               break;
            case YELLOW:
               tmpDec=3;
               break;
            case GREEN:
               tmpDec=4;
               break;
            case NODECISION:
               tmpDec=2;
               break;
            default:
               tmpDec=1;
         }
         if (tmpDec>retDecision) retDecision=tmpDec;
      }
      return decRank[retDecision];
   }
}