// ------------------------------- project object ----------------------------------------

var statusText=["Unstarted","Preparation","Attraction","Finalisation","Completed"];
var PROJECTSTATUS_UNSTARTED=0;
var PROJECTSTATUS_PREPARATION=1;
var PROJECTSTATUS_ATTRACTION=2;
var PROJECTSTATUS_FINALISATION=3;
var PROJECTSTATUS_COMPLETED=4;

var PROGRESSREPORT_FULL=0;
var PROGRESSREPORT_SHORT=1;
var PROGRESSREPORT_PHP=2;

var NOTUPLOADED="NOTUPLOADED";

function project(id,name,status,created) {
   this.isLoaded=false;
   this.companyIdList=new Array();
   this.companyNameList=new Array();
   this.companies=new Array();
   this.stats=new Array(); 
   this.profiler=new task(TASKTYPE_PROFILE,project.length-1,ALLSUBS);
   this.selector=new task(TASKTYPE_SELECTION,project.length-1,ALLSUBS);
   this.caller=new task(TASKTYPE_CALLING,project.length-1,ALLSUBS);
   this.meetingPlan=new task(TASKTYPE_MEETINGPLAN,project.length-1,ALLSUBS);
   this.report=new task(TASKTYPE_REPORT,project.length-1,ALLSUBS);
   this.created=new myDate(created);
   //
   this.companySelected=NOTSET;
   this.subProjectSelected=NOTSET;
   this.entrySelected=NOTSET;
   //
   this.profileFile=NOTUPLOADED;
   this.meetingPlanFile=NOTUPLOADED;
   this.reportFile=NOTUPLOADED;
   //
   this.clientName="";
   this.name=name;
   this.id=id;
   this.email="";
   this.contact="";
   this.country="";
   this.logo="";
   this.status=status;
   this.assignedto="";
   this.coordinator="";
   
   // methods
   this.processBlogName=processBlogName;
   this.processNoteText=processNoteText;
   this.assignWorker=assignWorker;
   this.loadData=loadData;
   this.buildRelations=buildRelations;
   this.processActivities=processActivities;
   this.calculateStats=calculateStats;
   this.collateErrors=collateErrors;
   this.countDecisions=countDecisions;
   this.generateProgressReport=generateProgressReport;
   this.changeStatus=changeStatus;
   this.addCompany=addCompany;
   
   // method functions
   function processBlogName() {
      // calculate client name & country from blog name
   }
   
   function processNoteText(text) {
      // read workers and deadlines from note text
   }
   
   function assignWorker(type,assignedTo,startDate,deadline,completedDate) {
      // complete task object for .profiler, .selector, .caller, etc.
      // if completedDate!="", then isCompleted=true
      // helpers addition and modifications done through task object methods
   }
   
   function loadData() {
      // (re)loads an entire project, project data + company data
      // need parameters to tell method what to do when finished??
      // and how to display progress?
   }
   
   function buildRelations() {
      // for all companies, puts contact data into contact objects & builds array, blog relations into an array
   }
   
   function processActivities(dateFrom) {
      // for current, pass NOTSET; calculates stats and errors at the same time 
   }
   
   function calculateStats(dateFrom) {
      // compute data for this.stats[NOW] or this.stats[OLD] (depending on dateFrom)
   }
   
   function collateErrors() {
      // get error strings from company error data
   }
   
   function countDecisions(useDate) {
      var decs=[0,0,0,0,0];
      // [nodec,r,y,g,on1st]
      
      var ind=(useDate) ?OLD :NOW;
      for (var i=0;i<this.companies.length;i++) {
         if (this.companies[i].isMultiple) {
            this.companies[i].status[ind]=this.companies[i].getMultipleDecision();
         } else {
            if (this.companies[i].subProjects.length==1) this.companies[i].status[ind]=this.companies[i].subProjects[0].status[ind];
            else this.companies[i].status[ind]=ONFIRSTCALL;
         }
         //alert("2 ("+i+" ....... "+this.companies[i].status[ind]);
         if (this.companies[i].status[ind]<0) decs[4]++;
         else decs[this.companies[i].status[ind]]++;
         //alert("3 ("+i);
      }
      return decs;
   }
   
   function generateProgressReport(type) {
      // returns 2D array for table creation - type=SHORT,FULL or PHP (returns string)
   }
   
   function changeStatus() {
      // add start/end notes to companies if necessary too
   }
   
   function addCompany() {
      // adds new company to project (used in data loading)
   }
}