/* notes!

   -- need to remove existing auto-text when changing entry type!

*/

// ------------------------------- settings object ----------------------------------------

var menuUPDATE=-1;
var menuLIST=0;
var menuOVERVIEW=1;
var menuPROGRESS=2;
var menuCLIENT=3;
var menuENHANCED=4;
var menuFULL=5;
var menuFINAL=6;
//
var SET_CALL=0;
var SET_NOTE=1;
var SET_PRIVATE=2;
var SET_EMAIL=3;
var SET_NONE=0;
var SET_RED=1;
var SET_YELLOW=2;
var SET_GREEN=3;

function settingsObject() {
   this.rootMenu=menuLIST;
   this.progressMenu=menuCLIENT;
   this.project=NOTSET;
   this.solveUpdates=new solveUpdate(NOTSET,NOTSET,NOTSET);
   this.caller="";
   //
   this.entryType=SET_CALL;
   this.no1=false;
   this.no2=false;
   this.first=false;
   this.decision=SET_NONE;
   this.plus=false;
   this.entryUnder=-1;
   //
   
   // methods
   this.addProject=addProject;
   this.addProjectSummary=addProjectSummary;
   this.show=show;
   this.showProgressReport=showProgressReport;
   this.initialiseList=initialiseList;
   this.getLoadedProjects=getLoadedProjects;
   this.showClientProgressReport=showClientProgressReport;
   this.selectCompany=selectCompany;
   this.solveEntryClick=solveEntryClick;
   
   // method functions
   function getLoadedProjects(proj) {
      var loadedList=new Array();
      for (var i=0;i<projects.length;i++) {
         if (projects[i].isLoaded && i!=proj) loadedList.push(i);
      }
      return loadedList;
   }
   
   function addProject(proj) {
      // add radio button
      var loadedProjects=this.getLoadedProjects(proj);
      var pos=NOTSET;
      var el=_new("input","projectRadio","projectRadio"+proj);
      el.setAttribute("type","radio");
      el.setAttribute("value",proj);
      el.setAttribute("name","projectRadioGroup");
      el.onclick=function() { settings.project=this.value; _goToMenu(menuUPDATE); };
      if (loadedProjects.length==0) {
         el.setAttribute("checked","checked");
         this.project=proj;
      } else {
         for (var i=0;i<loadedProjects.length && pos==NOTSET;i++) {
            if (proj<loadedProjects[i]) pos=loadedProjects[i];
         }
      }
      if (pos==NOTSET) _add("progressRadioBox",el);
      else _addBefore("progressRadioBox",el,"projectRadio"+pos);
      el=_newt("label",_shortened(projects[proj].name,19),"projectRadioLabel","projectRadioLabel"+proj);
      el.htmlFor="projectRadio"+proj;
      el.onclick=function() { settings.project=this.value; _goToMenu(menuUPDATE); };
      if (pos==NOTSET) {
         _add("progressRadioBox",el);
         _add("progressRadioBox",_new("br"));
      } else {
         _addBefore("progressRadioBox",el,"projectRadio"+pos);
         _addBefore("progressRadioBox",_new("br"),"projectRadio"+pos);
      }
   }
   
   function addProjectSummary(proj) {
      // add RYGwW div to summary screen
      var loadedProjects=this.getLoadedProjects(proj);
      var decs=projects[proj].countDecisions(false);  // [nodec,r,y,g,on1st]
      var pos=NOTSET;
      var div=_new("div","overviewProjectBox","overviewProjectBox"+proj);
      _addEl(div,_newt("h2",projects[proj].name,"overviewProjectBoxTitle","overviewProjectBoxTitle"+proj));
      _addEl(div,_newt("p",statusText[projects[proj].status],"bold overviewProjectBoxStatus","overviewProjectBoxStatus"+proj));
      _addEl(div,_newt("div",projects[proj].companies.length+" =","overviewProjectBoxTotal","overviewProjectBoxTotal"+proj));
      _addEl(div,_newt("div",decs[3],"overviewProjectBoxGreen","overviewProjectBoxGreen"+proj));
      _addEl(div,_newt("div",decs[2],"overviewProjectBoxYellow","overviewProjectBoxYellow"+proj));
      _addEl(div,_newt("div",decs[1],"overviewProjectBoxRed","overviewProjectBoxRed"+proj));
      _addEl(div,_newt("div",decs[4],"overviewProjectBoxFirst","overviewProjectBoxFirst"+proj));
      _addEl(div,_newt("div",decs[0],"overviewProjectBoxFollow","overviewProjectBoxFollow"+proj));
      _addEl(div,_newt("div","1st calls","overviewProjectBoxFirstLabel","overviewProjectBoxFirstLabel"+proj));
      _addEl(div,_newt("div","follow-ups","overviewProjectBoxFollowLabel","overviewProjectBoxFollowLabel"+proj));
      
      if (loadedProjects.length==0) {
         _add("summaryContainer",div);
      } else {
         for (var i=0;i<loadedProjects.length && pos==NOTSET;i++) {
            if (proj<loadedProjects[i]) pos=loadedProjects[i];
         }
         _addBefore("summaryContainer",div,"overviewProjectBox"+pos);
      }
   }
   
   function initialiseList(myProjects) {
      var MYPROJ_ID=0;
      var MYPROJ_NAME=1;
      var MYPROJ_STATUS=2;
      var MYPROJ_CREATED=3;
      var count=[0,0,0,0,0];
      this.caller=myProjects[0];
      for (var i=1;i<myProjects.length;i++) {
         var item=_newt("p",myProjects[i][MYPROJ_NAME],"projectListItem","pLI"+(i-1));
         item.onclick=function() { _selectedProjectListItem(this,this.id); };
         _add("projectsList"+myProjects[i][MYPROJ_STATUS],item);
         count[myProjects[i][MYPROJ_STATUS]]++;
         //
         // id,name,blogName,status,created
         projects.push(new project(myProjects[i][MYPROJ_ID],myProjects[i][MYPROJ_NAME],myProjects[i][MYPROJ_STATUS], myProjects[i][MYPROJ_CREATED]));
      }
      for (var i=0;i<5;i++) {
         if (count[i]==0) _hide("projectsList"+i);
      }
   }
   
   function show(opt) {
      var i,j;
      var divs=[["projectsMenu","projectsContainer",],
                ["summaryMenu","summaryContainer",],
                ["progressMenu","progressContainer",]];
      var disp=divs.splice(opt,1);
      for (i=0;i<divs.length;i++) {
         for (j=0;j<divs[i].length;j++) {
            _hide(divs[i][j]);
         }
      }
      for (i=0;i<disp[0].length;i++) {
         _show(disp[0][i]);
      }
      if (opt==menuPROGRESS) this.showProgressReport();
   }
   
   function showProgressReport() {
      switch (this.progressMenu) {
         case menuCLIENT:
            this.showClientProgressReport();
            break;
         case menuENHANCED:
            break;
         case menuFULL:
            break;
         case menuFINAL:
            break;
      }
   }
   
   function showClientProgressReport() {
      var comp,subp;
      _wipe("progressReportContainer");
      
      // build table and header
      var outer=_new("div","fixed-table-container");
      var inner=_new("div","fixed-table-container-inner","progressTableScrollContainer");
      var table=new myTable("progressTableClient"); 
      //var columnWidths=[-1,500,-1,-1,-1,-1,-1];
      //table.setColumnWidths(columnWidths);
      
      table.newRow("progressTableClientHeader0","complex-top");
      table.addHeaderSpan(1,2,"Nr.","th-inner","progressTableClientHeaderNr","complex-top doubleRow");
      table.addHeaderSpan(1,2,"Company name","progressBeige th-inner nameWidth","progressTableClientHeaderCompany","complex-top doubleRow");
      table.addHeaderSpan(3,1,"1st contact","progressGreen th-inner","progressTableClientHeaderFirst","complex-top singleRow");
      table.addHeaderSpan(2,1,"2nd contact: feedback","progressOrange th-inner","progressTableClientHeaderFollow","complex-top singleRow");

      table.newRow("progressTableClientHeader1","complex-bottom");
      table.addHeader("Contact name","progressSmall progressGreen th-inner contactWidth","progressTableClientHeaderContact","complex-bottom singleRow");
      table.addHeader("Date","progressSmall progressGreen th-inner dateWidth","progressTableClientHeaderDate1","complex-bottom singleRow");
      table.addHeader("Comments","progressSmall progressGreen th-inner","progressTableClientHeaderComment1","complex-bottom singleRow");
      table.addHeader("Date","progressSmall progressOrange th-inner dateWidth","progressTableClientHeaderDate2","complex-bottom singleRow");
      table.addHeader("Reply, comments","progressSmall progressOrange th-inner","progressTableClientHeaderComment2","complex-bottom singleRow");
      
      // name, #sub, overall colour,[colour,contacts,d1,c1,d2,c2,subName]
      //   0     1          2           3       4     5  6   7 8    9
      
      for (var i=0;i<projects[this.project].companies.length;i++) {
         var tDat=projects[this.project].companies[i].getCompanyTableEntry();
         if (tDat[1]==1) tDat[2]=tDat[3];
         table.newRow("progressTableClient"+_combine(i),tDat[3]);
         table.row.onclick=function() { settings.selectCompany(this.id,true); };
         table.addCellSpan(1,tDat[1],i+1,"progressTableClientNumb"+_combine(i),"numberSelected noBorder cellWHITE");
         table.addCellSpan(1,tDat[1],tDat[0],"progressTableClientComp"+_combine(i),tDat[2]+" nameWidth bold");
         
         if (tDat[9]!="") table.addRichCell("Re: "+tDat[9]+".",tDat[4],"progressTableClientCont"+_combine(i),"contactWidth");
         else table.addCell(tDat[4],"progressTableClientCont"+_combine(i),"contactWidth");
         
         table.addCell(tDat[5],"progressTableClient1Dat"+_combine(i),"dateWidth centred");
         table.addCell(tDat[6],"progressTableClient1Com"+_combine(i));
         table.addCell(tDat[7],"progressTableClient2Dat"+_combine(i),"dateWidth centred");
         table.addCell(tDat[8],"progressTableClient2Com"+_combine(i));
         if (tDat[1]>1) {     
            for (var j=1;j<tDat[1];j++) {
               table.newRow("progressTableClient"+_combine(i,j),tDat[3+j*7]);
               table.row.onclick=function() { settings.selectCompany(this.id,true); };
               if (tDat[9+j*7]!="") table.addRichCell("Re: "+tDat[9+j*7]+".",tDat[4+j*7],"progressTableClientCont"+_combine(i,j),"contactWidth");
               else table.addCell(tDat[4+j*7],"progressTableClientCont"+_combine(i,j),"contactWidth");
               table.addCell(tDat[5+j*7],"progressTableClient1Dat"+_combine(i,j),"dateWidth centred");
               table.addCell(tDat[6+j*7],"progressTableClient1Com"+_combine(i,j));
               table.addCell(tDat[7+j*7],"progressTableClient2Dat"+_combine(i,j),"dateWidth centred");
               table.addCell(tDat[8+j*7],"progressTableClient2Com"+_combine(i,j));
            }
         }
      }
      
      //_set(table.row,"title",projects[this.project].companies[i].getCompanyTitleText(_SHOW,_EXPAND,_SHOW));
      table.addRow();
            
      _addEl(inner,table.table);
      _addEl(outer,inner);
      _add("progressReportContainer",outer);
      settings.selectCompany("",false);
   }
   
   function selectCompany(idStr,isClick) {
      var projObj=projects[this.project];
      projObj.entrySelected=NOTSET;
      if (isClick) {
         var dat=_uncombine(idStr,"progressTableClient");
         if (projObj.companySelected!=dat[0] || projObj.subProjectSelected!=dat[1]) {
            projObj.companySelected=dat[0];
            projObj.subProjectSelected=dat[1];
         } else {
            projObj.companySelected=NOTSET;
            projObj.subProjectSelected=NOTSET;
         }
         if (this.solveUpdates.actions.length>0) this.solveUpdates.processUpdates();
         this.solveUpdates=new solveUpdate(NOTSET,NOTSET,NOTSET);
      }
      if (projObj.companySelected==NOTSET) {
         // black all companies
         for (var i=0;i<projObj.companies.length;i++) {
            for (var j=0;j<projObj.companies[i].subProjects.length;j++) {
               var rowClass=_get("progressTableClient"+_combine(i,j),"class");
               if (rowClass.indexOf("rowUnselected")!=NOTFOUND) _set(_el("progressTableClient"+_combine(i,j)),"class","rowSelected"+rowClass.slice(13));
            }
            var rowClass=_get("progressTableClientComp"+_combine(i),"class");
            if (rowClass.indexOf("rowUnselected")!=NOTFOUND) _set(_el("progressTableClientComp"+_combine(i)),"class","rowSelected"+rowClass.slice(13));
            rowClass=_get("progressTableClientNumb"+_combine(i),"class");
            if (rowClass.indexOf("numberUnselected")!=NOTFOUND) _set(_el("progressTableClientNumb"+_combine(i)),"class","numberSelected"+rowClass.slice(16));
         }
      } else {
         for (var i=0;i<projObj.companies.length;i++) {
            if (i==projObj.companySelected) {
               for (var j=0;j<projObj.companies[i].subProjects.length;j++) {
                  if (j==projObj.subProjectSelected) {
                     var rowClass=_get("progressTableClient"+_combine(i,j),"class");
                     if (rowClass.indexOf("rowUnselected")!=NOTFOUND) _set(_el("progressTableClient"+_combine(i,j)),"class","rowSelected"+rowClass.slice(13));
                  } else {
                     var rowClass=_get("progressTableClient"+_combine(i,j),"class");
                     if (rowClass.indexOf("rowSelected")!=NOTFOUND) _set(_el("progressTableClient"+_combine(i,j)),"class","rowUnselected"+rowClass.slice(11));
                  }
               }
            } else {
               for (var j=0;j<projObj.companies[i].subProjects.length;j++) {
                  var rowClass=_get("progressTableClient"+_combine(i,j),"class");
                  if (rowClass.indexOf("rowSelected")!=NOTFOUND) _set(_el("progressTableClient"+_combine(i,j)),"class","rowUnselected"+rowClass.slice(11));
               }
               var rowClass=_get("progressTableClientComp"+_combine(i),"class");
               if (rowClass.indexOf("rowSelected")!=NOTFOUND) _set(_el("progressTableClientComp"+_combine(i)),"class","rowUnselected"+rowClass.slice(11));
               rowClass=_get("progressTableClientNumb"+_combine(i),"class");
               if (rowClass.indexOf("numberSelected")!=NOTFOUND) _set(_el("progressTableClientNumb"+_combine(i)),"class","numberUnselected"+rowClass.slice(14));
            }
         }
         var rowClass=_get("progressTableClientComp"+_combine(projObj.companySelected),"class");
         if (rowClass.indexOf("rowUnselected")!=NOTFOUND) _set(_el("progressTableClientComp"+_combine(projObj.companySelected)),"class","rowSelected"+rowClass.slice(13));
         rowClass=_get("progressTableClientNumb"+_combine(projObj.companySelected),"class");
         if (rowClass.indexOf("numberUnselected")!=NOTFOUND) _set(_el("progressTableClientNumb"+_combine(projObj.companySelected)),"class","numberSelected"+rowClass.slice(16));
      }      
      
      if (projObj.companySelected!=NOTSET) {
         _show("solveContainer");
         _hide("actionListContainer");
         
         var compObj=projObj.companies[projObj.companySelected];
         this.solveUpdates=new solveUpdate(projObj,compObj,compObj.subProjects[projObj.subProjectSelected]);
         
         _write("companyDetailDataName",compObj.name);
         _write("companyDetailDataAddress",compObj.address);
         _write("websiteAnchor",compObj.website);
         _el("websiteAnchor").href=_convertHTTP(compObj.website,true);
         _write("companyDetailDataPhone",compObj.phone);
         _write("companyDetailDataEmail",compObj.email);
         _write("companyDetailDataRelatedProjects",compObj.getProjectRelationsList());
         _write("companyDetailDataBackground",compObj.background);
         _setDetailHeights();
         _resetSolveInputForm(projObj,compObj);   
         if (compObj.contactRelations.length>0) {
            // get most relevant contact
            var contactObj=_getRelevantContact(projObj,compObj);
            if (contactObj==false) {
               // wipe contact box
               _write("contactDetailDataName","");
               _write("contactDetailDataPosition","");
               _write("contactDetailDataEmail","");
               _write("contactDetailDataPhone","");
               _write("contactDetailDataMobile","");
               _write("contactDetailDataRelatedProjects","");
               _write("contactDetailDataCompany","");
               _write("contactDetailDataBackground","");
            } else {
               //var contactObj=contacts[compObj.contactRelations[0]]; 
               _write("contactDetailDataName",contactObj.name);
               _write("contactDetailDataPosition",contactObj.position);
               _write("contactDetailDataEmail",contactObj.email);
               _write("contactDetailDataPhone",contactObj.phone);
               _write("contactDetailDataMobile",contactObj.mobile);
               _write("contactDetailDataRelatedProjects",contactObj.getProjectRelationsList(projObj.name));
               _write("contactDetailDataCompany","");
               _write("contactDetailDataBackground","");
               //_setContactDetailHeights();
            }
         } else {
            // wipe contact box
            _write("contactDetailDataName","");
            _write("contactDetailDataPosition","");
            _write("contactDetailDataEmail","");
            _write("contactDetailDataPhone","");
            _write("contactDetailDataMobile","");
            _write("contactDetailDataRelatedProjects","");
            _write("contactDetailDataCompany","");
            _write("contactDetailDataBackground","");
         }
      } else {
         _hide("solveContainer");
         _show("actionListContainer");
      }
   }
   
   function solveEntryClick(id) {
      var projObj=projects[this.project];
      var compObj=projObj.companies[projObj.companySelected];
      projObj.entrySelected=id;
      //_createSolveEntryList(projObj,compObj);
      _resetSolveInputForm(projObj,compObj);
      _setSolveInputForm(projObj,compObj);
   }
}

function _setSolveInputForm(projObj,compObj) {
   var actObj=compObj.activities[projObj.entrySelected];
   if (actObj.no1) {
      settings.no1=true;
      _set(_el("callCodesNO1"),"class","toggleButtonSelected");
   } else if (actObj.no2) {
      settings.no2=true;
      _set(_el("callCodesNO2"),"class","toggleButtonSelected");
   }
   if (actObj.isFirst) {
      settings.first=true;
      _set(_el("callTags1"),"class","toggleButtonSelected");
   }
   if (actObj.isPlus) {
      settings.first=true;
      _set(_el("callTags+"),"class","toggleButtonSelected");
   }
   switch (actObj.decision) {
      case RED:
         settings.decision=SET_RED;
         _set(_el("callTagsRed"),"class","callTagsRedSelected");
         break;
      case YELLOW:
         settings.decision=SET_YELLOW;
         _set(_el("callTagsYellow"),"class","callTagsYellowSelected");
         break;
      case GREEN:
         settings.decision=SET_GREEN;
         _set(_el("callTagsGreen"),"class","callTagsGreenSelected");
         break;
   }  
   if (actObj.isPrivate) {
      _entryButtonClick("entryTypePrivate");
      _set(_el("entryTypePrivate"),"class","toggleButtonSelected");
      _set(_el("entryTypeNote"),"class","toggleButton");
      _set(_el("entryTypeCall"),"class","toggleButton");
   } else {
      _set(_el("entryTypePrivate"),"class","toggleButton");
      if (actObj.type==NOTE) {
         _entryButtonClick("entryTypeNote");
         _set(_el("entryTypeNote"),"class","toggleButtonSelected");
         _set(_el("entryTypeCall"),"class","toggleButton");
      } else {
         _entryButtonClick("entryTypeCall");
         _set(_el("entryTypeNote"),"class","toggleButton");
         _set(_el("entryTypeCall"),"class","toggleButtonSelected");
      }
   }
   if (actObj.isContactEntry) {
      // check contact
      var checkArray=[actObj.contact];
      _setChecked(checkArray,"entryUnderRadio");
   } else {
      _el("entryUnderRadio+").setAttribute("checked","checked");
   }
   _el("solveEntryInputBox").value=actObj.convertComment(compObj,_EXPAND,_EXPAND,_SHOW,_HIDESYSTEM);
   inputDate=actObj.date.convertToJavascriptDate();
   _displayDate();
}

function _resetSolveInputForm(projObj,compObj) {
   _setEntryFor(compObj);
   var selContact=_setEntryUnder(projObj,compObj);
   _createSolveEntryList(projObj,compObj);
   inputDate=new Date();
   _displayDate();
   if (selContact==-1) _el("solveEntryInputBox").value="";
   else _el("solveEntryInputBox").value=substitutions[3]+contacts[selContact].name+": ";
   settings.entryUnder=selContact;
   settings.entryType=SET_CALL;
   settings.no1=false;
   settings.no2=false;
   settings.first=false;
   settings.decision=SET_NONE;
   settings.plus=false;
   _ablingSolveTagButtons(false);
   // reset buttons
   _set(_el("entryTypeNote"),"class","toggleButton");
   _set(_el("entryTypePrivate"),"class","toggleButton");
   _set(_el("entryTypeEmail"),"class","toggleButton");
   _set(_el("callCodesNO1"),"class","toggleButton");
   _set(_el("callCodesNO2"),"class","toggleButton");
   _set(_el("callTags1"),"class","toggleButton");
   _set(_el("callTagsRed"),"class","toggleButton");
   _set(_el("callTagsYellow"),"class","toggleButton");
   _set(_el("callTagsGreen"),"class","toggleButton");
   _set(_el("callTags+"),"class","toggleButton");
   //
   _set(_el("entryTypeCall"),"class","toggleButtonSelected");
   _set(_el("solveInputEntryImage"),"class","solveEntryImage");
}

function _getRelevantContact(projObj,compObj) {
   var found=false;
   var foundList=new Array();
   var contactObj;
   var subObj=compObj.subProjects[projObj.subProjectSelected];
   var conContacts=subObj.con.length;
   
   if (conContacts>0) {
      contactObj=contacts[compObj.contactRelations[subObj.con[conContacts-1]]];
      found=true;
   }
   
   if (found) return contactObj;
   else return false;
}

function _displayDate() {
   var dStr=inputDate.toString();
   _write("solveEntryInputDateBoxDay",dStr.slice(0,3)+", "+_int(dStr.slice(8,10)));
   _write("solveEntryInputDateBoxMonth",dStr.slice(4,7)+" "+dStr.slice(11,15)); 
   _write("solveEntryInputDateBoxComma",",");
   _write("solveEntryInputDateBoxHour",dStr.slice(16,18));
   _write("solveEntryInputDateBoxColon",":");
   _write("solveEntryInputDateBoxMin",dStr.slice(19,21));
}

function _createSolveEntryList(projObj,compObj) {
   var isPRE=false;
   var el;
   var subObj=compObj.subProjects[projObj.subProjectSelected];
   
   _wipe("progressActivityViewerBox");
   _wipe("progressActivityViewerBoxPRE");
      
   for (var i=subObj.end;i<=subObj.start;i++) {      
      if (compObj.activities[i].type==CALL) var imStyle="solveEntryImage";
      else {
         if (compObj.activities[i].isPrivate) var imStyle="solveEntryImagePrivate";
         else var imStyle="solveEntryImageNote";
      }
      if (compObj.activities[i].isFirst) imStyle+="1";
      if (compObj.activities[i].commentText.length>0) {
         var className="solveEntryBox";
         if (i!=projObj.entrySelected) {
            switch (compObj.activities[i].decision) {
               case RED:
                  className+=" redEntry";
                  break;
               case YELLOW:
                  className+=" yellowEntry";
                  break;
               case GREEN:
                  className+=" greenEntry";
                  break;
            }
            el=_new("div",className,"solveEntryBox"+i);
            el.onclick=function() { settings.solveEntryClick(_int(this.id,13)); };
            _addEl(el,_newt("span",compObj.activities[i].date.solveDate(),"solveEntryDateSpan"));
            if (compObj.activities[i].isContactEntry) {
               _addEl(el,_newt("span",contacts[compObj.activities[i].contact].name,"solveEntryContactSpan"));
            }
            _addEl(el,_new("br"));
            _addEl(el,_newt("span",compObj.activities[i].convertComment(compObj,_SHOW,_SHOW,_SHOW,_SHOW)));
            if (i>projObj.entrySelected) {
               _add("progressActivityViewerBox",_new("div",imStyle,"solveEntryImage"+i));
               _add("progressActivityViewerBox",el);
            } else {
               _add("progressActivityViewerBoxPRE",_new("div",imStyle,"solveEntryImage"+i));
               _add("progressActivityViewerBoxPRE",el);
               isPRE=true;
            }
         }
      }
   }
   if (isPRE) {
      _el("progressActivityViewerBoxPRE").style.height="90px";
      _el("progressActivityViewerBox").style.height="200px";
   } else {
      _el("progressActivityViewerBoxPRE").style.height="0";
      _el("progressActivityViewerBox").style.height="290px";
   }
}

function _entryUnderClick(selContact) {
   if (settings.entryType!=SET_CALL) {
      if (selContact=="+") settings.entryUnder=-1;
      else settings.entryUnder=selContact;
   } else {
      if (settings.entryUnder!=-1) {
         var text=_el("solveEntryInputBox").value;
         var substStr=substitutions[3]+contacts[settings.entryUnder].name;
         if (text.indexOf(substStr)==0) {
            if (text.indexOf(substStr+":")==0) substStr+=":";
            _el("solveEntryInputBox").value=_tidyText(text.slice(substStr.length));
         }
      }
      if (settings.no2) {
         if (settings.entryUnder==-1) var substText=substitutions[1]+substitutions[2];
         else var substText=contacts[settings.entryUnder].name+substitutions[2];
         var text=_value("solveEntryInputBox");
         if (text.indexOf(substText)==0) {
            text=_tidyText(text.slice(substText.length));
            if (selContact=="+") substText=substitutions[1]+substitutions[2];
            else substText=contacts[selContact].name+substitutions[2];
            _el("solveEntryInputBox").value=substText+text;
         }
      }
      
      if (selContact=="+") {
         settings.entryUnder=-1;
      } else {
         var text=_el("solveEntryInputBox").value;
         if (text.indexOf(substitutions[3])!=0 && !settings.no1 && !settings.no2) {
            _el("solveEntryInputBox").value=substitutions[3]+contacts[selContact].name+": "+text;
         }
         settings.entryUnder=selContact;
      }
   }
}

function _setEntryUnder(projObj,compObj) {
   var subObj=compObj.subProjects[projObj.subProjectSelected];
   _wipe("entryUnderContainer");
   
   var el=_new("input","entryUnderRadio","entryUnderRadio+");
   el.setAttribute("type","radio");
   el.setAttribute("value","+");
   el.setAttribute("name","entryUnderGroup");
   
   if (subObj.con.length==0) {
      var selRadio=-1;
      el.setAttribute("checked","checked");
   } else {
      var selRadio=compObj.contactRelations[subObj.con[subObj.con.length-1]];
   }
   el.onclick=function() { _entryUnderClick(this.value); };
   _add("entryUnderContainer",el);
   el=_newt("label","Company","entryUnderRadioLabel","entryUnderRadioLabel+");
   el.htmlFor="entryUnderRadio+";
   _add("entryUnderContainer",el);
   
   if (selRadio!=-1) {
      el=_new("input","entryUnderRadio","entryUnderRadio"+selRadio);
      el.setAttribute("type","radio");
      el.setAttribute("value",selRadio);
      el.setAttribute("name","entryUnderGroup");
      el.setAttribute("checked","checked");
      el.onclick=function() { _entryUnderClick(this.value); };
      _add("entryUnderContainer",el);
      var name=_shortened(contacts[selRadio].name,30);
      if (contacts[selRadio].id=="NOTINSOLVE") name="("+name+")";
      el=_newt("label",name,"entryUnderRadioLabel","entryUnderRadioLabel"+selRadio);
      el.htmlFor="entryUnderRadio"+selRadio;
      _add("entryUnderContainer",el);
   }
   
   for (var i=0;i<compObj.contactRelations.length;i++) {
      if (compObj.contactRelations[i]!=selRadio) {
         var indx=compObj.contactRelations[i];
         el=_new("input","entryUnderRadio","entryUnderRadio"+indx);
         el.setAttribute("type","radio");
         el.setAttribute("value",indx);
         el.setAttribute("name","entryUnderGroup");
         el.onclick=function() { _entryUnderClick(this.value); };
         _add("entryUnderContainer",el);
         var name=_shortened(contacts[indx].name,30);
         if (contacts[indx].id=="NOTINSOLVE") name="("+name+")";
         el=_newt("label",name,"entryUnderRadioLabel","entryUnderRadioLabel"+indx);
         el.htmlFor="entryUnderRadio"+indx;
         _add("entryUnderContainer",el);
      }
   }   
   return selRadio;
}

function _setEntryFor(compObj) {
   _wipe("entryForContainer");
   var el=_new("input","entryForCheck","entryForCheck+");
   el.setAttribute("type","checkbox");
   el.setAttribute("value",compObj.project);
   //el.setAttribute("name","projectRadioGroup");
   //el.onclick=function() { settings.project=this.value; _goToMenu(menuUPDATE); };
   el.setAttribute("checked","checked");
   _add("entryForContainer",el);
   el=_newt("label",_shortened(compObj.project,11),"entryForCheckLabel","entryForCheckLabel+");
   el.htmlFor="entryForCheck+";
   //el.onclick=function() { settings.project=this.value; _goToMenu(menuUPDATE); };
   _add("entryForContainer",el);
   var addBreak=false;
   for (var i=0;i<compObj.projectRelations.length;i++) {
      if (compObj.projectRelations[i]!=compObj.project) {
         if (addBreak) el=_new("input","entryForCheckNL","entryForCheck"+i);
         else el=_new("input","entryForCheck","entryForCheck"+i);
         el.setAttribute("type","checkbox");
         el.setAttribute("value",compObj.projectRelations[i]);
         _add("entryForContainer",el);
         el=_newt("label",_shortened(compObj.projectRelations[i],11),"entryForCheckLabel","entryForCheckLabel"+i);
         el.htmlFor="entryForCheck"+i;
         _add("entryForContainer",el);
         addBreak=!addBreak;
      }
   }
}

function _convertHTTP(webAddress,addHTTP) {
   var isHTTP=false;
   if (webAddress.slice(0,4)=="http") var isHTTP=true;
   else var isHTTP=false;
   //
   if (addHTTP && !isHTTP) {
      webAddress="http://"+webAddress;
   }
   return webAddress;
}

function _launchWebsite() {
   var projObj=projects[settings.project];
   var webAddress=projObj.companies[projObj.companySelected].website;
   alert(webAddress);
}

function _setDetailHeights() {
   var detailFields=["companyDetailDataName","companyDetailDataAddress","companyDetailDataPhone","companyDetailDataEmail", "companyDetailDataRelatedProjects"];
   var detailContainers=["progressCompanyContainerName","progressCompanyContainerAddress","progressCompanyContainerPhone", "progressCompanyContainerEmail","progressCompanyContainerRelatedProjects"];
   var backgroundHeight=4;
   for (var i=0;i<detailContainers.length;i++) _set(_el(detailContainers[i]),"class","companyDetailContainer");
   for (var i=0;i<detailFields.length;i++) {
      var fieldObj=_el(detailFields[i]);
      if (fieldObj.scrollHeight/fieldObj.clientHeight>1 && backgroundHeight>0) {
         backgroundHeight--;
         _set(_el(detailContainers[i]),"class","companyDetailContainer doubleRowData");
      }
   }
   var backgroundClass="companyDetailContainer doubleRowData";
   if (backgroundHeight>0) backgroundClass+=backgroundHeight;
   _set(_el("progressCompanyContainerBackground"),"class",backgroundClass);
}

function _toggleButtons(buttonGroup,clickedID,canUnclick) {
   if (canUnclick && _get(clickedID,"class")!="toggleButton") {
      _set(_el(clickedID),"class","toggleButton");
   } else {
      switch (buttonGroup) {
         case "entryType":
            var buttonNames=["entryTypeCall","entryTypeNote","entryTypePrivate","entryTypeEmail"];
            break;
         case "callCodes":
            var buttonNames=["callCodesNO1","callCodesNO2"];
            break;
         case "callTags1":
         case "callTags+":
         case "miscTagsStart":
         case "miscTagsEnd":
         case "miscTagsUncontactable":
            var buttonNames=[buttonGroup];
            break;
         case "callTags":
            var buttonNames=["callTagsRed","callTagsYellow","callTagsGreen"];
            break;
      }
      for (var i=0;i<buttonNames.length;i++) {
         if (buttonNames[i]==clickedID) _set(_el(clickedID),"class","toggleButtonSelected");
         else _set(_el(buttonNames[i]),"class","toggleButton");
      }
      if (buttonGroup=="callTags") _set(_el(clickedID),"class",clickedID+"Selected");
   }
   
   switch (buttonGroup) {
      case "entryType":
         _entryButtonClick(clickedID);
         break;
      case "callCodes":
         var newText=_value("solveEntryInputBox");
         if (clickedID=="callCodesNO1") {
            if (settings.no1) newText=_removeSubstitution(newText,substitutions[0],false);
            settings.no1=!settings.no1;
            
            if (settings.entryUnder!=-1) {
               var substStr=substitutions[3]+contacts[settings.entryUnder].name;
               if (newText.indexOf(substStr)==0) {
                  if (newText.indexOf(substStr+":")==0) substStr+=":";
                  newText=_tidyText(newText.slice(substStr.length));
               }
            }
            
            if (settings.no2) {
               settings.no2=false;
               var checkedList=_findCheckedValues("entryUnderRadio");
               if (checkedList[0]==="+") var substText=substitutions[1]+substitutions[2];
               else var substText=contacts[checkedList[0]].name+substitutions[2];
               newText=_removeSubstitution(newText,substText,true);
            }
            if (settings.no1) newText=substitutions[0]+". "+newText;
         } else {
            // no2
            var checkedList=_findCheckedValues("entryUnderRadio");
            if (checkedList[0]==="+") var substText=substitutions[1]+substitutions[2];
            else var substText=contacts[checkedList[0]].name+substitutions[2];
            if (settings.no2) newText=_removeSubstitution(newText,substText,true);
            settings.no2=!settings.no2;
            
            if (settings.entryUnder!=-1) {
               var substStr=substitutions[3]+contacts[settings.entryUnder].name;
               if (newText.indexOf(substStr)==0) {
                  if (newText.indexOf(substStr+":")==0) substStr+=":";
                  newText=_tidyText(newText.slice(substStr.length));
               }
            }
            
            if (settings.no1) {
               newText=_removeSubstitution(newText,substitutions[0],false);
               settings.no1=false;
            }
            if (settings.no2) newText=substText+". "+newText;
         }
         if (!settings.no1 && !settings.no2 && settings.entryUnder!=-1) {
            newText=_tidyText(substitutions[3]+contacts[settings.entryUnder].name+": "+newText);
         }
         
         _el("solveEntryInputBox").value=newText;
         break;
      case "callTags1":
         settings.first=!settings.first;
         switch (settings.entryType) {
            case SET_CALL:
               _entryButtonClick("entryTypeCall");
               break;
            case SET_NOTE:
               _entryButtonClick("entryTypeNote");
               break;
            case SET_PRIVATE:
               _entryButtonClick("entryTypePrivate");
               break;
         }
      case "callTags+":
         settings.plus=!settings.plus;
      case "miscTagsStart":
      case "miscTagsEnd":
      case "miscTagsUncontactable":
         break;
      case "callTags":
         if (_get(clickedID,"class")!="toggleButton") {
            switch (clickedID) {
               case "callTagsRed":
                  settings.decision=SET_RED;
                  break;
               case "callTagsYellow":
                  settings.decision=SET_YELLOW;
                  break;
               case "callTagsGreen":
                  settings.decision=SET_GREEN;
                  break;
            }
         } else {
            settings.decision=SET_NONE;
         }
         break;
   }
   _el("solveEntryInputBox").focus();
}

function _removeSubstitution(newText,substText,isNo2) {
   if (newText.indexOf(substText)!=NOTFOUND) {
      var pos=newText.indexOf(substText);
      if (newText.indexOf(substText+". ")!=NOTFOUND) substText+=". ";
      newText=newText.slice(0,pos)+newText.slice(pos+substText.length);
   } else if (isNo2) {
      var tmpText=newText;
      var ctr=0;
      var uncheckedList=_findUncheckedValues("entryUnderRadio");
      while (tmpText==newText && ctr<uncheckedList.length) {
         if (uncheckedList[ctr]==="+") var substText=substitutions[1]+substitutions[2];
         else var substText=contacts[uncheckedList[ctr]].name+substitutions[2];
         newText=_removeSubstitution(newText,substText,false);
         ctr++;
      }
   }
   return newText;
}

function _ablingSolveTagButtons(disablingButtons,disablingCodes) {
   var buttonList=["callTags1","callTagsRed","callTagsYellow","callTagsGreen","callTags+"];
   var codeList=["callCodesNO1","callCodesNO2"];
   for (var i=0;i<buttonList.length;i++) {
      if (disablingButtons) {
         _disable(buttonList[i]);
         _el(buttonList[i]).setAttribute("class","toggleButton");
      }
      else _enable(buttonList[i]);
   }
   for (var i=0;i<codeList.length;i++) {
      if (disablingCodes) {
         _disable(codeList[i]);
         _el(codeList[i]).setAttribute("class","toggleButton");
      }
      else _enable(codeList[i]);
   }
   if (disablingCodes) {
      settings.no1=false;
      settings.no2=false;
   }
   if (disablingButtons) {
      settings.first=false;
      settings.decision=SET_NONE;
      settings.plus=false;
   }
}

function _entryButtonClick(clickedID) {
   var tagImage=(settings.first==true) ?"1" :"";
   switch (clickedID) {
      case "entryTypeCall":
         _set(_el("solveInputEntryImage"),"class","solveEntryImage"+tagImage);
         _ablingSolveTagButtons(false,false);
         settings.entryType=SET_CALL;
         break;
      case "entryTypeNote":
         _set(_el("solveInputEntryImage"),"class","solveEntryImageNote"+tagImage);
         _ablingSolveTagButtons(false,true);
         settings.entryType=SET_NOTE;
         break;
      case "entryTypePrivate":
         _set(_el("solveInputEntryImage"),"class","solveEntryImagePrivate");
         settings.entryType=SET_PRIVATE;
         _ablingSolveTagButtons(true,true);
         break;
   }
}