// ---------------------------------------- processing functions, used by objects ------------------------------------------
function _findContactFromId(id) {
   var found=NOTFOUND;
   for (var i=0;i<contacts.length && found==NOTFOUND;i++) {
      if (contacts[i].id==id) found=i;
   }
   return found;
}

function _findContactFromName(name,conList) {
   var found=NOTFOUND;
   name=name.toLowerCase();
   for (var i=0;i<conList.length && found==NOTFOUND;i++) {
      var conName=contacts[conList[i]].name.toLowerCase();
      if (conName.indexOf(name)!=NOTFOUND) found=i;
   }
   //if (found!=NOTFOUND) alert(name+" ... "+contacts[conList[found]].name);
   return found;
}

function _getTagList(text) {
   var tagList=new Array();
   var start,end;
   while ((start=text.indexOf("["))!=NOTFOUND) {
      end=text.indexOf("]");
      if (end==NOTFOUND) end=text.length-1;
      else tagList.push(text.slice(start+1,end));
      text=text.slice(0,start)+text.slice(end+1);
   }
   return tagList;
}

function _removeBoundary(text,bound) {
   var pos=text.indexOf(bound+"=");
   if (pos!=NOTFOUND) {
      return text.slice(pos+bound.length+1);
   } else {
      pos=text.indexOf("="+bound);
      if (pos!=NOTFOUND) {
         return text.slice(0,pos);
      } else {
         // error in start/end tag?????
         return "ERRORINBOUNDARYTAG";
      }
   }
}

// 0123456789'123456789'1234
// 2012-06-05T11:09:30+00:00
function _fixCommentDate(dateGiven,dateActual) {
   if (dateActual!="") {
      //return dateGiven.slice(0,13)+dateActual.slice(13,16);
      //var newww=dateActual.slice(0,10)+dateGiven.slice(10);
      //alert(dateGiven+"\n"+dateActual+"\n"+newww);
      //dateGiven=dateActual;
   }
   return dateGiven;
}

function _addPunctuation(text,colonPref) {
   var strText=_tidyText(text);
   if (strText=="") {
      text=".";
   } else {
      switch (strText.charAt(0)) {
         case ".":
         case ",":
         case ";":
         case ":":
         case "-":
            // return text as is
            break;
         default:
            if (colonPref) text=": "+strText;
            else {
               if (strText.charCodeAt(0)>=65 && strText.charCodeAt(0)<=90) text=". "+strText;
               else text=", "+strText;
            }
      }
   }
   return text;
}

function _hideBraces(text) {
   var start,end;
   while (text.indexOf("{")!=NOTFOUND) {
      start=text.indexOf("{");
      end=text.indexOf("}");
      if (end==NOTFOUND) end=text.length-1;
      text=text.slice(0,start)+text.slice(end+1);
   }
   return text;
}

function _getConName(text) {
   // text starting "con="
   var retData=["",""];
   if (text.charAt(4)=="'" || text.charAt(4)=="\"") {
      var subText=text.slice(5);
      var endChar=text.charAt(4);
      var pos=subText.indexOf(endChar);
   } else {
      var subText=text.slice(4);
      var pos=0;
      var stop=false;
      while (pos<subText.length && !stop) {
         if (subText.charAt(pos)==" " || subText.charAt(pos)=="," || subText.charAt(pos)=="." || subText.charAt(pos)==":" || subText.charAt(pos)==";") stop=true;
         pos++;
      }
      if (stop) pos--;
      else pos=NOTFOUND;
   }
   if (pos==NOTFOUND) pos=subText.length;
   
   retData[0]=subText.slice(0,pos);
   retData[1]=subText.slice(pos+1);
   return retData;
}

// -----------------------------------------------------------------------------
var SEARCH_CON=-2;
var SEARCH_ANY=-1;
var SEARCH_DECISION=0;
var SEARCH_FIRST=1;
var SEARCH_NOCODES=2;
//
function _searchActivities(dateFrom,subObj,start,end,type) {
   var found=NOTFOUND;
   if (type==SEARCH_CON) {
      for (var i=start;i>=end;i--) {
         //if (subObj.company.name=="Realbygg") alert("con checking: "+subObj.company.activities[i].comment);
         if (subObj.company.activities[i].checkValid(dateFrom,subObj,true) && subObj.company.activities[i].isCon) {
            //if (subObj.company.name=="Realbygg") alert("found con=");
            found=NOTFOUND;
            for (var j=0;j<subObj.con.length && found==NOTFOUND;j++) {
               if (subObj.con[j]==subObj.company.activities[i].conRef) found=j;
            }
            if (found==NOTFOUND) subObj.con.push(subObj.company.activities[i].conRef);
         }
      }
   } else {
      for (var i=end;i<=start && found==NOTFOUND;i++) {
         //if (subObj.company.name=="Realbygg") alert("checking: "+subObj.company.activities[i].comment);
         if (subObj.company.activities[i].checkValid(dateFrom,subObj,false)) {
            //if (subObj.company.name=="Realbygg") alert("valid");
            switch (type) {
               case SEARCH_FIRST:
                  if (subObj.company.activities[i].isFirst) found=i;
                  break;
               case SEARCH_DECISION:
                  if (subObj.company.activities[i].decision!=NOTSET) found=i;
                  break;
               case SEARCH_ANY:
                  found=i;
                  break;
               case SEARCH_NOCODES:
                  if (!subObj.company.activities[i].no1 && !subObj.company.activities[i].no2) found=i;
                  break;
            }
         }
         //else if (subObj.company.name=="Realbygg") alert("invalid");
      }
   }
   return found;
}

// -----------------------------------------------------------------------------
function _saveEntry() {
   var projObj=projects[settings.project];
   var compObj=projObj.companies[projObj.companySelected];
   var text=_tidyText(_value("solveEntryInputBox"));
   if (text.length>0) {
      // need to check text isn't just "con=~" (although {con=} or [!]con= is fine!
      //
      var x = document.getElementsByName("entryUnderGroup");
      for (var k=0;k<x.length;k++) {
         if (x[k].checked) {
            var selRadio=x[k].value;
            if (selRadio=="+") var type=UPDATE_COMPANY;
            else {
               var conObj=contacts[selRadio];
               var conId=conObj.id;
               if (conId=="NOTINSOLVE") var type=UPDATE_COMPANY;
               else var type=UPDATE_CONTACT;
            }
            if (type==UPDATE_CONTACT) var underId=conId;
            else var underId=settings.solveUpdates.comp.id;
         }
      }
      var action=UPDATE_NEWACTIVITY;
      if (projObj.entrySelected!=NOTSET) {
         action=UPDATE_EDITACTIVITY;
         actNumber=projObj.entrySelected;
         actId=compObj.activities[actNumber].id;
      } else {
         actId="*"+newActivityCounter;
         newActivityCounter++;
      }

      switch (settings.entryType) {
         case SET_CALL:
            var actType=CALL;
            break;
         case SET_NOTE:
         case SET_PRIVATE:
            var actType=NOTE;
            break;
      }
      // companyId/contactId,actType,date,comment,(actId, caller)
      if (action==UPDATE_NEWACTIVITY) var data=[underId,actType,_convertToSolveDate(inputDate),_getCommentFromInputBox(),actId];
      if (action==UPDATE_EDITACTIVITY) var data=[underId,actType,_convertToSolveDate(inputDate),_getCommentFromInputBox(),actId,actNumber];   
      
      var ind=settings.solveUpdates.actions.push(new solveUpdateAction(type,action,data));
      
      //if (type==UPDATE_COMPANY) -- if type=UP_CONTACT, then mark activity as contact entry!
      compObj.userAddModifyActivity(settings.solveUpdates.actions[ind-1]);
      
      var scrPos=_el("progressTableScrollContainer").scrollTop;
      settings.showClientProgressReport();
      _el("progressTableScrollContainer").scrollTop=scrPos;
   }
   _resetSolveInputForm(projObj,compObj);   
}

function _convertToSolveDate(d) {
   var day="0"+d.getDate();
   var monthNum=1+d.getMonth();
   var month="0"+monthNum;
   var year=""+d.getFullYear();
   var hours="0"+d.getHours();
   var mins="0"+d.getMinutes();
   var secs="0"+d.getSeconds();
   
   var dateStr=year+"-"+month.slice(-2)+"-"+day.slice(-2)+"T"+hours.slice(-2)+":"+mins.slice(-2)+":"+secs.slice(-2);
   dateStr+="+00:00*";   
   //alert(dateStr);
   return dateStr;
}

function _getCommentFromInputBox() {
   return _value("solveEntryInputBox");
}

function _findCheckedValues(className) {
   var retData=new Array();
   var x=document.getElementsByClassName(className);
   for (var i=0;i<x.length;i++) {
      if (x[i].checked==true || x[i].checked=="checked") retData.push(x[i].value);
   }
   return retData;
}

function _findUncheckedValues(className) {
   var retData=new Array();
   var x=document.getElementsByClassName(className);
   for (var i=0;i<x.length;i++) {
      if (x[i].checked!=true && x[i].checked!="checked") retData.push(x[i].value);
   }
   return retData;
}

function _setChecked(checkArray,className) {
   var x=document.getElementsByClassName(className);
   for (var i=0;i<x.length;i++) {
      for (var j=0;j<checkArray.length;j++) {
         if (x[i].value==checkArray[j]) x[i].checked="checked";
      }
   }
}