<!DOCTYPE html>
<html>
   <head>
      <title>Relating Tool</title>
      <?php
         define('USER', 'jesse.turner@gatewaybaltic.com');
         define('TOKEN', 'reNaj8P1B4r3y9=fD8RaM0a4Lf30sdBda1d210we'); 
         require 'Solve360Service.php';
         $solve360Service = new Solve360Service(USER, TOKEN);
         $projects = $solve360Service->getAllProjectblogs();
         $data=array();
         foreach ($projects->children() as $ch) {
            $title=$ch->title;
            $id=$ch->id;
            if (strlen($title)>0) $data[]=array("$title","$id");
         }

         $tags = $solve360Service->getCompanyCategories();
         $tagdata=array();
         foreach ($tags->categories->children() as $ch) {
            $name=$ch->name;
            $id=$ch->id;
            if (strstr($name,'Imported')!=False) {
               $tagdata[]=array("$name","$id");
            }
         }
         array_multisort($tagdata);
      ?>
      <script type="text/javascript" src="library_functions.js"></script>
      <script type="text/javascript">
         var blogs;
         var tags;
         
         var companies=new Array();
         var counter;
         var NAME=0;
         var ID=1;
         var MODIFIED=2;
         var RELATED=3;
         
         function loadData() {
            var blogName=_value("enterBlog");
            var sel=_el("enterImport");
            var importID=sel[sel.selectedIndex].value;
            var blogID=-1;
            for (var i=0;i<blogs.length;i++) {
               if (blogs[i][0]==blogName) blogID=blogs[i][1];
            }
            if (blogID==-1) {
               alert("Error - Blog name not recognised!");
            } else {
               var xmlhttp;
   	         if (window.XMLHttpRequest) xmlhttp=new XMLHttpRequest();
   	         else xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
   	      
   	         xmlhttp.onreadystatechange=function() {
   	            if (xmlhttp.readyState==4 && xmlhttp.status==200) {
   		            var data=JSON.parse(xmlhttp.responseText);
   		            if (data[0].length>0) {
      		            for (var i=0;i<data[0].length;i++) {
      		               companies.push([data[0][i],-1,-1,true]);
   	   	            }
   	   	         }
   	   	         if (data[1].length>0) {
      		            for (var i=0;i<data[1].length;i++) {
      		               var rel=false;
      		               for (var j=0;j<data[0].length && !rel;j++) {
      		                  if (data[1][i][0]==data[0][j]) rel=true;
      		               }
      		               companies.push([data[1][i][0],data[1][i][1],data[1][i][2],rel]);
   	   	            }
   	   	            setSelectBox();
   	   	            _enable("relateButton");
   	   	            _enable("loadButton");
   	   	         } else {
      		            _enable("loadButton");
   	   	         }
                  }
               }
               _disable("loadButton");
               var node=_el("blogList");
               while(node.firstChild) node.removeChild(node.firstChild);
               var node=_el("importList");
               while(node.firstChild) node.removeChild(node.firstChild);
   
               xmlhttp.open("GET","loadBlogImportData.php?b="+blogID+"&i="+importID,true);
               xmlhttp.send();
            }
         }
         
         function setSelectBox() {
            var sel=_el("chooseImport");
            while(sel.firstChild) sel.removeChild(sel.firstChild);       
            var opts=new Array();
            for (var i=0;i<companies.length;i++) {
               var found=false;
               if (companies[i][MODIFIED]!=-1) {
                  var tt=companies[i][MODIFIED].slice(11,16);
                  for (var j=0;j<opts.length && !found;j++) {
                     if (opts[j]==tt) found=true;
                  }
                  if (!found) opts.push(tt);
               }
            }
            for (var i=0;i<opts.length;i++) {
               var el=_new("option");
               el.value=opts[i];
               el.text=opts[i];
               _add("chooseImport",el);
            }
            var el=_new("option");
            el.value="All";
            el.text="All";
            _add("chooseImport",el);
            updateList();
         }
         
         function updateList() {
            var node=_el("importList");
            while(node.firstChild) node.removeChild(node.firstChild);
            var node=_el("blogList");
            while(node.firstChild) node.removeChild(node.firstChild);
            
            var sel=_el("chooseImport");
            var choice=sel[sel.selectedIndex].value;
            
            for (var i=0;i<companies.length;i++) {
               if (companies[i][RELATED]) {
                  var el=_newt("p",companies[i][NAME]);
      		      _add("blogList",el);
      		   }
      		   if (companies[i][MODIFIED]!=-1) {
                  if (choice=="All" || choice==companies[i][MODIFIED].slice(11,16)) {
                     if (companies[i][RELATED]) var el=_newt("p",companies[i][NAME],"greyed");
                     else var el=_newt("p",companies[i][NAME]);
      		         _add("importList",el);
      		      }
      		   }
      		   //_write("importTitle","Companies to be related ("+imported.length+"):");
            } 
         }
         
         function relateData() {
            var blogName=_value("enterBlog");
            var blogID;
            for (var i=0;i<blogs.length;i++) {
               if (blogs[i][0]==blogName) blogID=blogs[i][1];
            }
            _disable("loadButton");
            _disable("relateButton");
            
            var sel=_el("chooseImport");
            var choice=sel[sel.selectedIndex].value;
            if (choice=="All") {
               counter=imported.length;
               for (var i=0;i<imported.length;i++) {
                  relateCompany(blogID,i,imported[i][1]);
               }
            } else {
               counter=0;
               for (var i=0;i<imported.length;i++) {
                  if (imported[i][2].slice(11,16)==choice) {
                     counter++;
                     relateCompany(blogID,i,imported[i][1]);
                  }
               }
            }
         }
            
         function relateCompany(blogID,compNum,comp) {
            var xmlhttp;
	         if (window.XMLHttpRequest) xmlhttp=new XMLHttpRequest();
	         else xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	      
	         xmlhttp.onreadystatechange=function() {
	            if (xmlhttp.readyState==4 && xmlhttp.status==200) {
		            var compNum=JSON.parse(xmlhttp.responseText);
		            imported[compNum][3]=true;
		            counter--;
		            if (counter==0) finishedRelating();
               }
            }

            xmlhttp.open("GET","relateCompany.php?c="+comp+"&b="+blogID+"&n="+compNum,true);
            xmlhttp.send();
         }
         
         function finishedRelating() {
            var node=_el("importList");
            while(node.firstChild) node.removeChild(node.firstChild);
            if (existing==0) {
               var node=_el("blogList");
               while(node.firstChild) node.removeChild(node.firstChild);
            }
            var sel=_el("chooseImport");
            var choice=sel[sel.selectedIndex].value;
            if (choice=="All") {
               for (var i=0;i<imported.length;i++) {
                  var el=_newt("p",imported[i][0]);
         		   _add("blogList",el);
      	   	}
      		   existing+=imported.length;
      		} else {
      		   var ctr=0;
      		   for (var i=0;i<imported.length;i++) {
      		      if (imported[i][2].slice(11,16)==choice) {
                     var el=_newt("p",imported[i][0]);
         		      _add("blogList",el);
         		      ctr++;
         		   }
      	   	}
      	   	existing+=ctr;
      	   }
      		_write("blogTitle","Companies currently on project blog ("+existing+"):");
      		_enable("loadButton");
         }
         
      </script>
      <style type="text/css">
         body { margin:20px; padding:0; font-family:arial,sans-serif; position:relative; }
         p,label { font-size:12px; }
         .italic { font-style:italic; }
         .bold { font-weight:bold; }
         #blogTitle { position: absolute; top:30px; left:450px; }
         #blogList { position: absolute; top:60px; left:450px; width:400px; height:500px; border:1px solid black; margin:0; padding:0; overflow-x:hidden; overflow-y:auto; }
         #importTitle { position: absolute; top:30px; left:900px; }
         #importList { position: absolute; top:60px; left:900px; width:400px; height:500px; border:1px solid black; margin:0; padding:0; overflow-x:hidden; overflow-y:auto; }
         #chooseImport { position: absolute; top:580px; left:900px; }
         #enterBlog { width:350px; }
         
         .greyed { color:grey; }
      </style>
   </head>
   <body>
      <label for="enterBlog">Project blog:</label>
      <input list="projBlogs" id="enterBlog"/>
      <datalist id="projBlogs">
      </datalist>
      <br/>
      <label for="enterImport">Import tag:</label>
      <select id="enterImport"></select>
      <br/><br/>
      <button id="loadButton" onclick="loadData()">Load</button>
      <button id="relateButton" onclick="relateData()">Relate</button>
      <p id="blogTitle" class="bold">Companies currently on project blog:</p>
      <div id="blogList"></div>
      <p id="importTitle" class="bold">Companies to be related:</p>
      <div id="importList"></div>
      <select id="chooseImport" onchange="updateList()"></select>
   </body>
   <script type="text/javascript">
      _disable("relateButton");
      blogs = <?php echo json_encode($data); ?>;
      for (var i=0;i<blogs.length;i++) {
         var el=_new("option");
         el.setAttribute("value",blogs[i][0]);
         _add("projBlogs",el);
      }
      tags = <?php echo json_encode($tagdata); ?>;
      for (var i=0;i<tags.length;i++) {
         var el=_new("option");
         el.value=tags[i][1];
         el.text=tags[i][0];
         _add("enterImport",el);
      }
   </script>
</html> 
