// --------------------------------- string handling ---------------------------------------
function _int(str,pos) {
   if (pos!=undefined) str=str.slice(pos);
   return parseInt(str,10);
}

function _capitalise(name) {
   var cap,rest;
   var nameParts=name.split(" ");
   for (var i=0;i<nameParts.length;i++) {
      rest=nameParts[i].slice(1);
      cap=nameParts[i].charAt(0);
      if (i==0) name=cap.toUpperCase()+rest;
      else name+=" "+cap.toUpperCase()+rest;
   }
   return name;
}

function _cmp(str1,str2) {
   if (str1.indexOf(str2)>=0 && str2.indexOf(str1)>=0) return true;
   else return false;
}

function _icmp(str1,str2) {
   //alert(str1+"--"+str2);
   if (str1==undefined || str2==undefined) return false;
   else {
      str1=str1.toLowerCase();
      str2=str2.toLowerCase();
      return _cmp(str1,str2);
   }
}

//
// ********************************************************************************************
// ********************************************************************************************
//
// --------------------------------- element selection ---------------------------------------
function _el(id) {
   return document.getElementById(id);
}

// --------------------------------- element deletion ---------------------------------------
function _del(parEl,chEl) {
   // both parameters are IDs
   _el(parEl).removeChild(_el(chEl));
}

function _wipe(elName) {
   var el=_el(elName);
   while (el.hasChildNodes()) el.removeChild(el.lastChild);
}

// --------------------------------- element creation -------------------------------------
function _newt(el,text,elClass,id) {
   var elmt=document.createElement(el);
   elmt.appendChild(document.createTextNode(text));
   if (elClass!=undefined) elmt.setAttribute("class",elClass);
   if (id!=undefined) elmt.setAttribute("id",id);
   return elmt;
}

function _new(el,elClass,id) {
   var elmt=document.createElement(el);
   if (elClass!=undefined) elmt.setAttribute("class",elClass);
   if (id!=undefined) elmt.setAttribute("id",id);
   return elmt;
}

function _add(parEl,chEl) {
   // parEl is ID; chEl is element
   _el(parEl).appendChild(chEl);
}

function _addEl(parEl,chEl) {
   parEl.appendChild(chEl);
}

function _addBefore(parEl,chEl,befEl) {
   // parEl is ID; chEl is element; befEl is ID
   _el(parEl).insertBefore(chEl,_el(befEl));
}

// --------------------------------- element manipulation ---------------------------------------
function _set(el,attrib,attValue) {
   el.setAttribute(attrib,attValue);
}

function _get(el,attrib) {
   return _el(el).getAttribute(attrib);
}

function _style(el,styleValue) {
   el.setAttribute("style",styleValue);
}

// --------------------------------- element display ---------------------------------------
function _hide(id) {
   _el(id).style.display="none";
}

function _invis(id) {
   _el(id).style.visibility="hidden";
}

function _show(id) {
   _el(id).style.display="";
   _el(id).style.visibility="";
}

function _enable(id) {
   _el(id).disabled=false;
}

function _disable(id) {
   _el(id).disabled=true;
}

// --------------------------------- element content ------------------------------------
function _write(id,text) {
   _el(id).innerHTML=text;
}

function _addWrite(id,text) {
   _el(id).innerHTML+=text;
}

function _read(id) {
   return _el(id).innerHTML;
}

function _value(id) {
   return _el(id).value;
}

//
// ********************************************************************************************
// ********************************************************************************************
//
// --------------------------------- table object ------------------------------------

// styling tables by multiple classes (e.g. class="t_CENTER t_ITALIC")
// have t_GREEN, t_YELLOW, etc.
//
function myTable(id,elClass) {
   this.id=id;
   if (elClass==undefined) var elClass="";
   this.class=elClass;
   this.table=_new("table",elClass,id);
   this.row="";
   this.cell="";
   this.isRow=false;
   
   // methods
   this.newRow=newRow;
   this.addCell=addCell;
   this.addHeader=addHeader;
   this.addSimpleHeader=addSimpleHeader;
   this.addHeaderSpan=addHeaderSpan;
   this.addRow=addRow;
   this.addCellToRow=addCellToRow;
   this.addTable=addTable;
   this.setColumnWidths=setColumnWidths;
   this.addCellSpan=addCellSpan;
   this.addRichCell=addRichCell;
   
   // method functions
   function setColumnWidths(columnWidths) {
      var colgroup=_new("colgroup");
      var col;
      for (var i=0;i<columnWidths.length;i++) {
         col=_new("col");
         col.setAttribute("span","1");
         if (columnWidths[i]!=-1) col.setAttribute("style","min-width:"+columnWidths[i]+"px;");
         _addEL(colgroup,col);
      }
      _addEl(this.table,colgroup);
   }
   
   function addTable(parentID) {
      if (this.isRow) this.addRow();
      _add(parentID,this.table);
   }
   
   function newRow(id,elClass) {
      if (this.isRow) this.addRow();
      this.isRow=true;
      if (id==undefined) this.row=_new("tr");
      else if (elClass==undefined) this.row=_new("tr","",id);
      else this.row=_new("tr",elClass,id);
   }
   
   function addRow() {
      _addEl(this.table,this.row);
      this.isRow=false;
   }
   
   function addCellToRow() {
      _addEl(this.row,this.cell);
   }
   
   function addCell(text,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_newt("td",text,elClass);
      else this.cell=_newt("td",text,elClass,id);
      this.addCellToRow();
   }
   
   function addRichCell(richtext,text,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_new("td",elClass);
      else this.cell=_new("td",elClass,id);
      _addEl(this.cell,_newt("span",richtext,"bold tableText"));
      _addEl(this.cell,_new("br"));
      _addEl(this.cell,_newt("span",text,"tableText"));
      this.addCellToRow();
   }
   
   function addCellSpan(colsp,rowsp,text,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_newt("td",text,elClass);
      else this.cell=_newt("td",text,elClass,id);
      this.cell.colSpan=colsp;
      this.cell.rowSpan=rowsp;
      this.addCellToRow();
   }
   
   function addSimpleHeader(text,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_newt("th",text,elClass);
      else this.cell=_newt("th",text,elClass,id);
      this.addCellToRow();     
   }
   
   function addHeader(text,innerClass,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_new("th",elClass);
      else this.cell=_new("th",elClass,id);
      _addEl(this.cell,_newt("div",text,innerClass));
      this.addCellToRow();     
   }
   
   function addHeaderSpan(colsp,rowsp,text,innerClass,id,elClass) {
      if (elClass==undefined) var elClass="";
      if (id==undefined) this.cell=_new("th",elClass);
      else this.cell=_new("th",elClass,id);
      this.cell.colSpan=colsp;
      this.cell.rowSpan=rowsp;
      _addEl(this.cell,_newt("div",text,innerClass));
      this.addCellToRow();
   }   
}
